/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.redstone;

import com.simibubi.create.content.logistics.block.redstone.StockpileSwitchBlock;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class StockpileSwitchTileEntity
extends SmartTileEntity {
    public float onWhenAbove = 0.75f;
    public float offWhenBelow = 0.25f;
    public float currentLevel = -1.0f;
    public boolean powered = false;
    private LazyOptional<IItemHandler> observedInventory = LazyOptional.empty();

    public StockpileSwitchTileEntity(TileEntityType<?> typeIn) {
        super(typeIn);
        this.setLazyTickRate(10);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        this.onWhenAbove = compound.func_74760_g("OnAbove");
        this.offWhenBelow = compound.func_74760_g("OffBelow");
        this.currentLevel = compound.func_74760_g("Current");
        this.powered = compound.func_74767_n("Powered");
        super.func_145839_a(compound);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74776_a("OnAbove", this.onWhenAbove);
        compound.func_74776_a("OffBelow", this.offWhenBelow);
        compound.func_74776_a("Current", this.currentLevel);
        compound.func_74757_a("Powered", this.powered);
        return super.func_189515_b(compound);
    }

    public float getLevel() {
        return this.currentLevel;
    }

    public void updateCurrentLevel() {
        if (!this.observedInventory.isPresent()) {
            if (!this.findNewInventory() && this.currentLevel != -1.0f) {
                this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)StockpileSwitchBlock.INDICATOR, (Comparable)Integer.valueOf(0)), 3);
                this.currentLevel = -1.0f;
                this.powered = false;
                this.field_145850_b.func_195592_c(this.field_174879_c, this.func_195044_w().func_177230_c());
            }
            return;
        }
        float occupied = 0.0f;
        float totalSpace = 0.0f;
        IItemHandler inv = (IItemHandler)this.observedInventory.orElse(null);
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stackInSlot = inv.getStackInSlot(slot);
            int space = Math.min(stackInSlot.func_77976_d(), inv.getSlotLimit(slot));
            int count = stackInSlot.func_190916_E();
            if (space == 0) continue;
            totalSpace += 1.0f;
            occupied += (float)count * (1.0f / (float)space);
        }
        this.currentLevel = occupied / totalSpace;
        this.currentLevel = MathHelper.func_76131_a((float)this.currentLevel, (float)0.0f, (float)1.0f);
        boolean previouslyPowered = this.powered;
        if (this.powered && this.currentLevel <= this.offWhenBelow) {
            this.powered = false;
        } else if (!this.powered && this.currentLevel >= this.onWhenAbove) {
            this.powered = true;
        }
        boolean update = previouslyPowered != this.powered;
        int displayLevel = 0;
        if (this.currentLevel > 0.0f) {
            displayLevel = (int)(this.currentLevel * 6.0f);
        }
        this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((IProperty)StockpileSwitchBlock.INDICATOR, (Comparable)Integer.valueOf(displayLevel)), update ? 3 : 2);
        if (update) {
            this.field_145850_b.func_195592_c(this.field_174879_c, this.func_195044_w().func_177230_c());
        }
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.findNewInventory();
        this.updateCurrentLevel();
    }

    private boolean findNewInventory() {
        this.observedInventory = LazyOptional.empty();
        BlockPos invPos = this.func_174877_v().func_177972_a((Direction)this.func_195044_w().func_177229_b((IProperty)BlockStateProperties.field_208157_J));
        if (!this.field_145850_b.func_195588_v(invPos)) {
            return false;
        }
        BlockState invState = this.field_145850_b.func_180495_p(invPos);
        if (!invState.hasTileEntity()) {
            return false;
        }
        TileEntity invTE = this.field_145850_b.func_175625_s(invPos);
        if (invTE == null) {
            return false;
        }
        this.observedInventory = invTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
        if (this.observedInventory.isPresent()) {
            this.updateCurrentLevel();
            return true;
        }
        return false;
    }

    @Override
    public void addBehaviours(List<TileEntityBehaviour> behaviours) {
    }
}

