/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.INBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public abstract class AbstractFilterContainer
extends Container {
    public PlayerEntity player;
    protected PlayerInventory playerInventory;
    public ItemStack filterItem;
    public ItemStackHandler filterInventory;

    protected AbstractFilterContainer(ContainerType<?> type, int id, PlayerInventory inv, PacketBuffer extraData) {
        this(type, id, inv, extraData.func_150791_c());
    }

    protected AbstractFilterContainer(ContainerType<?> type, int id, PlayerInventory inv, ItemStack filterItem) {
        super(type, id);
        this.player = inv.field_70458_d;
        this.playerInventory = inv;
        this.filterItem = filterItem;
        this.init();
    }

    protected void init() {
        this.filterInventory = this.createFilterInventory();
        this.readData(this.filterItem);
        this.addPlayerSlots();
        this.addFilterSlots();
        this.func_75142_b();
    }

    protected void clearContents() {
        for (int i = 0; i < this.filterInventory.getSlots(); ++i) {
            this.filterInventory.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    protected abstract int getInventoryOffset();

    protected abstract void addFilterSlots();

    protected abstract ItemStackHandler createFilterInventory();

    protected abstract void readData(ItemStack var1);

    protected abstract void saveData(ItemStack var1);

    protected void addPlayerSlots() {
        int x = 58;
        int y = 28 + this.getInventoryOffset();
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            this.func_75146_a(new Slot((IInventory)this.playerInventory, hotbarSlot, x + hotbarSlot * 18, y + 58));
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.func_75146_a(new Slot((IInventory)this.playerInventory, col + row * 9 + 9, x + col * 18, y + row * 18));
            }
        }
    }

    public boolean func_94530_a(ItemStack stack, Slot slotIn) {
        return this.func_94531_b(slotIn);
    }

    public boolean func_94531_b(Slot slotIn) {
        return slotIn.field_75224_c == this.playerInventory;
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return true;
    }

    public ItemStack func_184996_a(int slotId, int dragType, ClickType clickTypeIn, PlayerEntity player) {
        if (slotId == this.playerInventory.field_70461_c && clickTypeIn != ClickType.THROW) {
            return ItemStack.field_190927_a;
        }
        ItemStack held = this.playerInventory.func_70445_o();
        if (slotId < 36) {
            return super.func_184996_a(slotId, dragType, clickTypeIn, player);
        }
        if (clickTypeIn == ClickType.THROW) {
            return ItemStack.field_190927_a;
        }
        int slot = slotId - 36;
        if (clickTypeIn == ClickType.CLONE) {
            if (player.func_184812_l_() && held.func_190926_b()) {
                ItemStack stackInSlot = this.filterInventory.getStackInSlot(slot).func_77946_l();
                stackInSlot.func_190920_e(64);
                this.playerInventory.func_70437_b(stackInSlot);
                return ItemStack.field_190927_a;
            }
            return ItemStack.field_190927_a;
        }
        if (held.func_190926_b()) {
            this.filterInventory.setStackInSlot(slot, ItemStack.field_190927_a);
            return ItemStack.field_190927_a;
        }
        ItemStack insert = held.func_77946_l();
        insert.func_190920_e(1);
        this.filterInventory.setStackInSlot(slot, insert);
        return held;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        if (index < 36) {
            ItemStack stack;
            ItemStack stackToInsert = this.playerInventory.func_70301_a(index);
            for (int i = 0; i < this.filterInventory.getSlots() && !ItemHandlerHelper.canItemStacksStack((ItemStack)(stack = this.filterInventory.getStackInSlot(i)), (ItemStack)stackToInsert); ++i) {
                if (!stack.func_190926_b()) continue;
                ItemStack copy = stackToInsert.func_77946_l();
                copy.func_190920_e(1);
                this.filterInventory.insertItem(i, copy, false);
                break;
            }
        } else {
            this.filterInventory.extractItem(index - 36, 1, false);
        }
        return ItemStack.field_190927_a;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.filterItem.func_196082_o().func_218657_a("Items", (INBT)this.filterInventory.serializeNBT());
        this.saveData(this.filterItem);
    }
}

