/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.item.filter;

import com.google.common.base.Predicates;
import com.simibubi.create.content.logistics.InWorldProcessing;
import com.simibubi.create.foundation.utility.Lang;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.AbstractFurnaceTileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.apache.commons.lang3.StringUtils;

public interface ItemAttribute {
    public static final List<ItemAttribute> types = new ArrayList<ItemAttribute>();
    public static final ItemAttribute standard = ItemAttribute.register(StandardTraits.DUMMY);
    public static final ItemAttribute inTag = ItemAttribute.register(new InTag(new ResourceLocation("dummy")));
    public static final ItemAttribute inItemGroup = ItemAttribute.register(new InItemGroup(ItemGroup.field_78026_f));
    public static final ItemAttribute addedBy = ItemAttribute.register(new AddedBy("dummy"));

    public static ItemAttribute register(ItemAttribute attributeType) {
        types.add(attributeType);
        return attributeType;
    }

    default public boolean appliesTo(ItemStack stack, World world) {
        return this.appliesTo(stack);
    }

    public boolean appliesTo(ItemStack var1);

    default public List<ItemAttribute> listAttributesOf(ItemStack stack, World world) {
        return this.listAttributesOf(stack);
    }

    public List<ItemAttribute> listAttributesOf(ItemStack var1);

    public String getTranslationKey();

    public void writeNBT(CompoundNBT var1);

    public ItemAttribute readNBT(CompoundNBT var1);

    default public void serializeNBT(CompoundNBT nbt) {
        CompoundNBT compound = new CompoundNBT();
        this.writeNBT(compound);
        nbt.func_218657_a(this.getNBTKey(), (INBT)compound);
    }

    public static ItemAttribute fromNBT(CompoundNBT nbt) {
        for (ItemAttribute itemAttribute : types) {
            if (!itemAttribute.canRead(nbt)) continue;
            return itemAttribute.readNBT(nbt.func_74775_l(itemAttribute.getNBTKey()));
        }
        return null;
    }

    default public Object[] getTranslationParameters() {
        return new String[0];
    }

    default public boolean canRead(CompoundNBT nbt) {
        return nbt.func_74764_b(this.getNBTKey());
    }

    default public String getNBTKey() {
        return this.getTranslationKey();
    }

    @OnlyIn(value=Dist.CLIENT)
    default public String format() {
        return Lang.translate("item_attributes." + this.getTranslationKey(), this.getTranslationParameters());
    }

    public static class AddedBy
    implements ItemAttribute {
        private String modId;

        public AddedBy(String modId) {
            this.modId = modId;
        }

        @Override
        public boolean appliesTo(ItemStack stack) {
            return this.modId.equals(stack.func_77973_b().getCreatorModId(stack));
        }

        @Override
        public List<ItemAttribute> listAttributesOf(ItemStack stack) {
            String id = stack.func_77973_b().getCreatorModId(stack);
            return id == null ? Collections.emptyList() : Arrays.asList(new AddedBy(id));
        }

        @Override
        public String getTranslationKey() {
            return "added_by";
        }

        @Override
        public Object[] getTranslationParameters() {
            Optional modContainerById = ModList.get().getModContainerById(this.modId);
            String name = modContainerById.map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(StringUtils.capitalize((String)this.modId));
            return new Object[]{name};
        }

        @Override
        public void writeNBT(CompoundNBT nbt) {
            nbt.func_74778_a("id", this.modId);
        }

        @Override
        public ItemAttribute readNBT(CompoundNBT nbt) {
            return new AddedBy(nbt.func_74779_i("id"));
        }
    }

    public static class InItemGroup
    implements ItemAttribute {
        private ItemGroup group;

        public InItemGroup(ItemGroup group) {
            this.group = group;
        }

        @Override
        public boolean appliesTo(ItemStack stack) {
            Item item = stack.func_77973_b();
            return item.func_77640_w() == this.group;
        }

        @Override
        public List<ItemAttribute> listAttributesOf(ItemStack stack) {
            ItemGroup group = stack.func_77973_b().func_77640_w();
            return group == null ? Collections.emptyList() : Arrays.asList(new InItemGroup(group));
        }

        @Override
        public String getTranslationKey() {
            return "in_item_group";
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public String format() {
            return Lang.translate("item_attributes." + this.getTranslationKey(), I18n.func_135052_a((String)this.group.func_78024_c(), (Object[])new Object[0]));
        }

        @Override
        public void writeNBT(CompoundNBT nbt) {
            nbt.func_74778_a("path", this.group.func_200300_c());
        }

        @Override
        public ItemAttribute readNBT(CompoundNBT nbt) {
            String readPath = nbt.func_74779_i("path");
            for (ItemGroup group : ItemGroup.field_78032_a) {
                if (!group.func_200300_c().equals(readPath)) continue;
                return new InItemGroup(group);
            }
            return null;
        }
    }

    public static class InTag
    implements ItemAttribute {
        ResourceLocation tagName;

        public InTag(ResourceLocation tagName) {
            this.tagName = tagName;
        }

        @Override
        public boolean appliesTo(ItemStack stack) {
            return stack.func_77973_b().getTags().contains(this.tagName);
        }

        @Override
        public List<ItemAttribute> listAttributesOf(ItemStack stack) {
            return stack.func_77973_b().getTags().stream().map(InTag::new).collect(Collectors.toList());
        }

        @Override
        public String getTranslationKey() {
            return "in_tag";
        }

        @Override
        public Object[] getTranslationParameters() {
            return new Object[]{"#" + this.tagName.toString()};
        }

        @Override
        public void writeNBT(CompoundNBT nbt) {
            nbt.func_74778_a("space", this.tagName.func_110624_b());
            nbt.func_74778_a("path", this.tagName.func_110623_a());
        }

        @Override
        public ItemAttribute readNBT(CompoundNBT nbt) {
            return new InTag(new ResourceLocation(nbt.func_74779_i("space"), nbt.func_74779_i("path")));
        }
    }

    public static enum StandardTraits implements ItemAttribute
    {
        DUMMY(s -> false),
        PLACEABLE(s -> s.func_77973_b() instanceof BlockItem),
        CONSUMABLE(ItemStack::func_222117_E),
        ENCHANTED(ItemStack::func_77948_v),
        DAMAGED(ItemStack::func_77951_h),
        BADLY_DAMAGED(s -> s.func_77951_h() && (float)(s.func_77952_i() / s.func_77958_k()) > 0.75f),
        NOT_STACKABLE((Predicate<ItemStack>)Predicates.not(ItemStack::func_77985_e)),
        EQUIPABLE(s -> s.getEquipmentSlot() != null),
        FURNACE_FUEL(AbstractFurnaceTileEntity::func_213991_b),
        WASHABLE(InWorldProcessing::isWashable),
        SMELTABLE((s, w) -> StandardTraits.testRecipe(s, w, (IRecipeType<? extends IRecipe<IInventory>>)IRecipeType.field_222150_b)),
        SMOKABLE((s, w) -> StandardTraits.testRecipe(s, w, (IRecipeType<? extends IRecipe<IInventory>>)IRecipeType.field_222152_d)),
        BLASTABLE((s, w) -> StandardTraits.testRecipe(s, w, (IRecipeType<? extends IRecipe<IInventory>>)IRecipeType.field_222151_c));

        private static final RecipeWrapper RECIPE_WRAPPER;
        private Predicate<ItemStack> test;
        private BiPredicate<ItemStack, World> testWithWorld;

        private StandardTraits(Predicate<ItemStack> test) {
            this.test = test;
        }

        private static boolean testRecipe(ItemStack s, World w, IRecipeType<? extends IRecipe<IInventory>> smelting) {
            RECIPE_WRAPPER.func_70299_a(0, s.func_77946_l());
            return w.func_199532_z().func_215371_a(smelting, (IInventory)RECIPE_WRAPPER, w).isPresent();
        }

        private StandardTraits(BiPredicate<ItemStack, World> test) {
            this.testWithWorld = test;
        }

        @Override
        public boolean appliesTo(ItemStack stack, World world) {
            if (this.testWithWorld != null) {
                return this.testWithWorld.test(stack, world);
            }
            return this.appliesTo(stack);
        }

        @Override
        public boolean appliesTo(ItemStack stack) {
            return this.test.test(stack);
        }

        @Override
        public List<ItemAttribute> listAttributesOf(ItemStack stack, World world) {
            ArrayList<ItemAttribute> attributes = new ArrayList<ItemAttribute>();
            for (StandardTraits trait : StandardTraits.values()) {
                if (!trait.appliesTo(stack, world)) continue;
                attributes.add(trait);
            }
            return attributes;
        }

        @Override
        public List<ItemAttribute> listAttributesOf(ItemStack stack) {
            return null;
        }

        @Override
        public String getTranslationKey() {
            return Lang.asId(this.name());
        }

        @Override
        public String getNBTKey() {
            return "standard_trait";
        }

        @Override
        public void writeNBT(CompoundNBT nbt) {
            nbt.func_74757_a(this.name(), true);
        }

        @Override
        public ItemAttribute readNBT(CompoundNBT nbt) {
            for (StandardTraits trait : StandardTraits.values()) {
                if (!nbt.func_74764_b(trait.name())) continue;
                return trait;
            }
            return null;
        }

        static {
            RECIPE_WRAPPER = new RecipeWrapper((IItemHandlerModifiable)new ItemStackHandler(1));
        }
    }
}

