/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.simibubi.create.Create;
import com.simibubi.create.content.schematics.packet.SchematicUploadPacket;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClientSchematicLoader {
    public static final int PACKET_DELAY = 10;
    private List<String> availableSchematics = new ArrayList<String>();
    private Map<String, InputStream> activeUploads = new HashMap<String, InputStream>();
    private int packetCycle;

    public ClientSchematicLoader() {
        this.refresh();
    }

    public void tick() {
        if (this.activeUploads.isEmpty()) {
            return;
        }
        if (this.packetCycle-- > 0) {
            return;
        }
        this.packetCycle = 10;
        for (String schematic : new HashSet<String>(this.activeUploads.keySet())) {
            this.continueUpload(schematic);
        }
    }

    public void startNewUpload(String schematic) {
        Path path = Paths.get("schematics", schematic);
        if (!Files.exists(path, new LinkOption[0])) {
            Create.logger.fatal("Missing Schematic file: " + path.toString());
            return;
        }
        try {
            long size = Files.size(path);
            Integer maxSize = (Integer)AllConfigs.SERVER.schematics.maxTotalSchematicSize.get();
            if (size > (long)(maxSize * 1000)) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(Lang.translate("schematics.uploadTooLarge", new Object[0]) + " (" + size / 1000L + " KB)."));
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new StringTextComponent(Lang.translate("schematics.maxAllowedSize", new Object[0]) + " " + maxSize + " KB"));
                return;
            }
            InputStream in = Files.newInputStream(path, StandardOpenOption.READ);
            this.activeUploads.put(schematic, in);
            AllPackets.channel.sendToServer((Object)SchematicUploadPacket.begin(schematic, size));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void continueUpload(String schematic) {
        if (this.activeUploads.containsKey(schematic)) {
            Integer maxPacketSize = (Integer)AllConfigs.SERVER.schematics.maxSchematicPacketSize.get();
            byte[] data = new byte[maxPacketSize.intValue()];
            try {
                int status = this.activeUploads.get(schematic).read(data);
                if (status != -1) {
                    if (status < maxPacketSize) {
                        data = Arrays.copyOf(data, status);
                    }
                    if (Minecraft.func_71410_x().field_71441_e != null) {
                        AllPackets.channel.sendToServer((Object)SchematicUploadPacket.write(schematic, data));
                    } else {
                        this.activeUploads.remove(schematic);
                        return;
                    }
                }
                if (status < maxPacketSize) {
                    this.finishUpload(schematic);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void finishUpload(String schematic) {
        if (this.activeUploads.containsKey(schematic)) {
            AllPackets.channel.sendToServer((Object)SchematicUploadPacket.finish(schematic));
            this.activeUploads.remove(schematic);
        }
    }

    public void refresh() {
        FilesHelper.createFolderIfMissing("schematics");
        this.availableSchematics.clear();
        try {
            Files.list(Paths.get("schematics/", new String[0])).filter(f -> !Files.isDirectory(f, new LinkOption[0]) && f.getFileName().toString().endsWith(".nbt")).forEach(path -> {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    return;
                }
                this.availableSchematics.add(path.getFileName().toString());
            });
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<String> getAvailableSchematics() {
        return this.availableSchematics;
    }

    public Path getPath(String name) {
        return Paths.get("schematics", name + ".nbt");
    }
}

