/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.schematics.block.SchematicTableTileEntity;
import com.simibubi.create.content.schematics.item.SchematicItem;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.config.CSchematics;
import com.simibubi.create.foundation.utility.FilesHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class ServerSchematicLoader {
    private Map<String, SchematicUploadEntry> activeUploads = new HashMap<String, SchematicUploadEntry>();

    public String getSchematicPath() {
        return "schematics/uploaded";
    }

    public void tick() {
        HashSet<String> deadEntries = new HashSet<String>();
        for (String upload : this.activeUploads.keySet()) {
            SchematicUploadEntry entry = this.activeUploads.get(upload);
            if (entry.idleTime++ <= (Integer)this.getConfig().schematicIdleTimeout.get()) continue;
            Create.logger.warn("Schematic Upload timed out: " + upload);
            deadEntries.add(upload);
        }
        deadEntries.forEach(this::cancelUpload);
    }

    public void shutdown() {
        new HashSet<String>(this.activeUploads.keySet()).forEach(this::cancelUpload);
    }

    public void handleNewUpload(ServerPlayerEntity player, String schematic, long size, BlockPos pos) {
        Integer maxFileSize;
        String playerPath = this.getSchematicPath() + "/" + player.func_200200_C_().func_150254_d();
        String playerSchematicId = player.func_200200_C_().func_150254_d() + "/" + schematic;
        FilesHelper.createFolderIfMissing(playerPath);
        if (!schematic.endsWith(".nbt")) {
            Create.logger.warn("Attempted Schematic Upload with non-supported Format: " + playerSchematicId);
        }
        if (size > (long)((maxFileSize = (Integer)this.getConfig().maxTotalSchematicSize.get()) * 1000)) {
            player.func_145747_a(new TranslationTextComponent("create.schematics.uploadTooLarge", new Object[0]).func_150257_a((ITextComponent)new StringTextComponent(" (" + size / 1000L + " KB).")));
            player.func_145747_a(new TranslationTextComponent("create.schematics.maxAllowedSize", new Object[0]).func_150257_a((ITextComponent)new StringTextComponent(" " + maxFileSize + " KB")));
            return;
        }
        if (this.activeUploads.containsKey(playerSchematicId)) {
            return;
        }
        try {
            SchematicTableTileEntity table = this.getTable(player.func_130014_f_(), pos);
            if (table == null) {
                return;
            }
            Files.deleteIfExists(Paths.get(this.getSchematicPath(), playerSchematicId));
            Stream<Path> list = Files.list(Paths.get(playerPath, new String[0]));
            if (list.count() >= (long)((Integer)this.getConfig().maxSchematics.get()).intValue()) {
                Stream<Path> list2 = Files.list(Paths.get(playerPath, new String[0]));
                Optional<Path> lastFilePath = list2.filter(f -> !Files.isDirectory(f, new LinkOption[0])).min(Comparator.comparingLong(f -> f.toFile().lastModified()));
                list2.close();
                if (lastFilePath.isPresent()) {
                    Files.deleteIfExists(lastFilePath.get());
                }
            }
            list.close();
            OutputStream writer = Files.newOutputStream(Paths.get(this.getSchematicPath(), playerSchematicId), StandardOpenOption.CREATE_NEW);
            this.activeUploads.put(playerSchematicId, new SchematicUploadEntry(writer, size, (World)player.func_71121_q(), pos));
            table.startUpload(schematic);
        }
        catch (IOException e) {
            Create.logger.error("Exception Thrown when starting Upload: " + playerSchematicId);
            e.printStackTrace();
        }
    }

    public CSchematics getConfig() {
        return AllConfigs.SERVER.schematics;
    }

    public void handleWriteRequest(ServerPlayerEntity player, String schematic, byte[] data) {
        String playerSchematicId = player.func_200200_C_().func_150254_d() + "/" + schematic;
        if (this.activeUploads.containsKey(playerSchematicId)) {
            SchematicUploadEntry entry = this.activeUploads.get(playerSchematicId);
            entry.bytesUploaded += (long)data.length;
            if (data.length > (Integer)this.getConfig().maxSchematicPacketSize.get()) {
                Create.logger.warn("Oversized Upload Packet received: " + playerSchematicId);
                this.cancelUpload(playerSchematicId);
                return;
            }
            if (entry.bytesUploaded > entry.totalBytes) {
                Create.logger.warn("Received more data than Expected: " + playerSchematicId);
                this.cancelUpload(playerSchematicId);
                return;
            }
            try {
                entry.stream.write(data);
                entry.idleTime = 0;
                SchematicTableTileEntity table = this.getTable(entry.world, entry.tablePos);
                if (table == null) {
                    return;
                }
                table.uploadingProgress = (float)((double)entry.bytesUploaded / (double)entry.totalBytes);
                table.sendUpdate = true;
            }
            catch (IOException e) {
                Create.logger.error("Exception Thrown when uploading Schematic: " + playerSchematicId);
                e.printStackTrace();
                this.cancelUpload(playerSchematicId);
            }
        }
    }

    protected void cancelUpload(String playerSchematicId) {
        if (!this.activeUploads.containsKey(playerSchematicId)) {
            return;
        }
        SchematicUploadEntry entry = this.activeUploads.remove(playerSchematicId);
        try {
            entry.stream.close();
            Files.deleteIfExists(Paths.get(this.getSchematicPath(), playerSchematicId));
            Create.logger.warn("Cancelled Schematic Upload: " + playerSchematicId);
        }
        catch (IOException e) {
            Create.logger.error("Exception Thrown when cancelling Upload: " + playerSchematicId);
            e.printStackTrace();
        }
        BlockPos pos = entry.tablePos;
        if (pos == null) {
            return;
        }
        SchematicTableTileEntity table = this.getTable(entry.world, pos);
        if (table != null) {
            table.finishUpload();
        }
    }

    public SchematicTableTileEntity getTable(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof SchematicTableTileEntity)) {
            return null;
        }
        SchematicTableTileEntity table = (SchematicTableTileEntity)te;
        return table;
    }

    public void handleFinishedUpload(ServerPlayerEntity player, String schematic) {
        String playerSchematicId = player.func_200200_C_().func_150254_d() + "/" + schematic;
        if (this.activeUploads.containsKey(playerSchematicId)) {
            try {
                this.activeUploads.get((Object)playerSchematicId).stream.close();
                SchematicUploadEntry removed = this.activeUploads.remove(playerSchematicId);
                World world = removed.world;
                BlockPos pos = removed.tablePos;
                Create.logger.info("New Schematic Uploaded: " + playerSchematicId);
                if (pos == null) {
                    return;
                }
                BlockState blockState = world.func_180495_p(pos);
                if (AllBlocks.SCHEMATIC_TABLE.get() != blockState.func_177230_c()) {
                    return;
                }
                SchematicTableTileEntity table = this.getTable(world, pos);
                if (table == null) {
                    return;
                }
                table.finishUpload();
                table.inventory.setStackInSlot(1, SchematicItem.create(schematic, player.func_200200_C_().func_150254_d()));
            }
            catch (IOException e) {
                Create.logger.error("Exception Thrown when finishing Upload: " + playerSchematicId);
                e.printStackTrace();
            }
        }
    }

    public class SchematicUploadEntry {
        public World world;
        public BlockPos tablePos;
        public OutputStream stream;
        public long bytesUploaded;
        public long totalBytes;
        public int idleTime;

        public SchematicUploadEntry(OutputStream stream, long totalBytes, World world, BlockPos tablePos) {
            this.stream = stream;
            this.totalBytes = totalBytes;
            this.tablePos = tablePos;
            this.world = world;
            this.bytesUploaded = 0L;
            this.idleTime = 0;
        }
    }
}

