/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.schematics.SchematicWorld;
import com.simibubi.create.content.schematics.client.SchematicHotbarSlotOverlay;
import com.simibubi.create.content.schematics.client.SchematicRenderer;
import com.simibubi.create.content.schematics.client.SchematicTransformation;
import com.simibubi.create.content.schematics.client.tools.Tools;
import com.simibubi.create.content.schematics.item.SchematicItem;
import com.simibubi.create.content.schematics.packet.SchematicPlacePacket;
import com.simibubi.create.foundation.gui.ToolSelectionScreen;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.NbtPacket;
import com.simibubi.create.foundation.renderState.SuperRenderTypeBuffer;
import com.simibubi.create.foundation.utility.outliner.AABBOutline;
import java.util.List;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Mirror;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.Template;

public class SchematicHandler {
    private String displayedSchematic;
    private SchematicTransformation transformation;
    private AxisAlignedBB bounds;
    private boolean deployed;
    private boolean active;
    private Tools currentTool;
    private static final int SYNC_DELAY = 10;
    private int syncCooldown;
    private int activeHotbarSlot;
    private ItemStack activeSchematicItem;
    private AABBOutline outline;
    private Vector<SchematicRenderer> renderers = new Vector(3);
    private SchematicHotbarSlotOverlay overlay;
    private ToolSelectionScreen selectionScreen;

    public SchematicHandler() {
        for (int i = 0; i < this.renderers.capacity(); ++i) {
            this.renderers.add(new SchematicRenderer());
        }
        this.overlay = new SchematicHotbarSlotOverlay();
        this.currentTool = Tools.Deploy;
        this.selectionScreen = new ToolSelectionScreen((List<Tools>)ImmutableList.of((Object)((Object)Tools.Deploy)), this::equip);
        this.transformation = new SchematicTransformation();
    }

    public void tick() {
        ItemStack stack;
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (this.activeSchematicItem != null && this.transformation != null) {
            this.transformation.tick();
        }
        if ((stack = this.findBlueprintInHand((PlayerEntity)player)) == null) {
            this.active = false;
            this.syncCooldown = 0;
            if (this.activeSchematicItem != null && this.itemLost((PlayerEntity)player)) {
                this.activeHotbarSlot = 0;
                this.activeSchematicItem = null;
                this.renderers.forEach(r -> r.setActive(false));
            }
            return;
        }
        if (!this.active || !stack.func_77978_p().func_74779_i("File").equals(this.displayedSchematic)) {
            this.init(player, stack);
        }
        if (!this.active) {
            return;
        }
        this.renderers.forEach(SchematicRenderer::tick);
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
        }
        if (this.syncCooldown == 1) {
            this.sync();
        }
        this.selectionScreen.update();
        this.currentTool.getTool().updateSelection();
    }

    private void init(ClientPlayerEntity player, ItemStack stack) {
        this.loadSettings(stack);
        this.displayedSchematic = stack.func_77978_p().func_74779_i("File");
        this.active = true;
        if (this.deployed) {
            this.setupRenderer();
            Tools toolBefore = this.currentTool;
            this.selectionScreen = new ToolSelectionScreen(Tools.getTools(player.func_184812_l_()), this::equip);
            if (toolBefore != null) {
                this.selectionScreen.setSelectedElement(toolBefore);
                this.equip(toolBefore);
            }
        } else {
            this.selectionScreen = new ToolSelectionScreen((List<Tools>)ImmutableList.of((Object)((Object)Tools.Deploy)), this::equip);
        }
    }

    private void setupRenderer() {
        Template schematic = SchematicItem.loadSchematic(this.activeSchematicItem);
        BlockPos size = schematic.func_186259_a();
        if (size.equals((Object)BlockPos.field_177992_a)) {
            return;
        }
        ClientWorld clientWorld = Minecraft.func_71410_x().field_71441_e;
        SchematicWorld w = new SchematicWorld((World)clientWorld);
        SchematicWorld wMirroredFB = new SchematicWorld((World)clientWorld);
        SchematicWorld wMirroredLR = new SchematicWorld((World)clientWorld);
        PlacementSettings placementSettings = new PlacementSettings();
        schematic.func_186253_b((IWorld)w, BlockPos.field_177992_a, placementSettings);
        placementSettings.func_186214_a(Mirror.FRONT_BACK);
        schematic.func_186253_b((IWorld)wMirroredFB, BlockPos.field_177992_a.func_177965_g(size.func_177958_n() - 1), placementSettings);
        placementSettings.func_186214_a(Mirror.LEFT_RIGHT);
        schematic.func_186253_b((IWorld)wMirroredLR, BlockPos.field_177992_a.func_177970_e(size.func_177952_p() - 1), placementSettings);
        this.renderers.get(0).display(w);
        this.renderers.get(1).display(wMirroredFB);
        this.renderers.get(2).display(wMirroredLR);
    }

    public void render(MatrixStack ms, SuperRenderTypeBuffer buffer) {
        boolean present;
        boolean bl = present = this.activeSchematicItem != null;
        if (!this.active && !present) {
            return;
        }
        if (this.active) {
            ms.func_227860_a_();
            this.currentTool.getTool().renderTool(ms, buffer);
            ms.func_227865_b_();
        }
        ms.func_227860_a_();
        this.transformation.applyGLTransformations(ms);
        if (!this.renderers.isEmpty()) {
            boolean fb;
            float pt = Minecraft.func_71410_x().func_184121_ak();
            boolean lr = this.transformation.getScaleLR().get(pt) < 0.0f;
            boolean bl2 = fb = this.transformation.getScaleFB().get(pt) < 0.0f;
            if (lr && !fb) {
                this.renderers.get(2).render(ms, buffer);
            } else if (fb && !lr) {
                this.renderers.get(1).render(ms, buffer);
            } else {
                this.renderers.get(0).render(ms, buffer);
            }
        }
        if (this.active) {
            this.currentTool.getTool().renderOnSchematic(ms, buffer);
        }
        ms.func_227865_b_();
    }

    public void renderOverlay(MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (!this.active) {
            return;
        }
        if (this.activeSchematicItem != null) {
            this.overlay.renderOn(this.activeHotbarSlot);
        }
        this.currentTool.getTool().renderOverlay(ms, buffer);
        this.selectionScreen.renderPassive(Minecraft.func_71410_x().func_184121_ak());
    }

    public void onMouseInput(int button, boolean pressed) {
        if (!this.active) {
            return;
        }
        if (!pressed || button != 1) {
            return;
        }
        if (Minecraft.func_71410_x().field_71439_g.func_225608_bj_()) {
            return;
        }
        this.currentTool.getTool().handleRightClick();
    }

    public void onKeyInput(int key, boolean pressed) {
        if (!this.active) {
            return;
        }
        if (key != AllKeys.TOOL_MENU.getBoundCode()) {
            return;
        }
        if (pressed && !this.selectionScreen.focused) {
            this.selectionScreen.focused = true;
        }
        if (!pressed && this.selectionScreen.focused) {
            this.selectionScreen.focused = false;
            this.selectionScreen.onClose();
        }
    }

    public boolean mouseScrolled(double delta) {
        if (!this.active || Minecraft.func_71410_x().field_71439_g.func_225608_bj_()) {
            return false;
        }
        if (this.selectionScreen.focused) {
            this.selectionScreen.cycle((int)delta);
            return true;
        }
        if (AllKeys.ACTIVATE_TOOL.isPressed()) {
            return this.currentTool.getTool().handleMouseWheel(delta);
        }
        return false;
    }

    private ItemStack findBlueprintInHand(PlayerEntity player) {
        ItemStack stack = player.func_184614_ca();
        if (!AllItems.SCHEMATIC.isIn(stack)) {
            return null;
        }
        if (!stack.func_77942_o()) {
            return null;
        }
        this.activeSchematicItem = stack;
        this.activeHotbarSlot = player.field_71071_by.field_70461_c;
        return stack;
    }

    private boolean itemLost(PlayerEntity player) {
        for (int i = 0; i < PlayerInventory.func_70451_h(); ++i) {
            if (!player.field_71071_by.func_70301_a(i).func_77969_a(this.activeSchematicItem) || !ItemStack.func_77970_a((ItemStack)player.field_71071_by.func_70301_a(i), (ItemStack)this.activeSchematicItem)) continue;
            return false;
        }
        return true;
    }

    public void markDirty() {
        this.syncCooldown = 10;
    }

    public void sync() {
        if (this.activeSchematicItem == null) {
            return;
        }
        PlacementSettings settings = this.transformation.toSettings();
        CompoundNBT tag = this.activeSchematicItem.func_77978_p();
        tag.func_74757_a("Deployed", this.deployed);
        tag.func_218657_a("Anchor", (INBT)NBTUtil.func_186859_a((BlockPos)this.transformation.getAnchor()));
        tag.func_74778_a("Rotation", settings.func_186215_c().name());
        tag.func_74778_a("Mirror", settings.func_186212_b().name());
        AllPackets.channel.sendToServer((Object)new NbtPacket(this.activeSchematicItem, this.activeHotbarSlot));
    }

    public void equip(Tools tool) {
        this.currentTool = tool;
        this.currentTool.getTool().init();
    }

    public void loadSettings(ItemStack blueprint) {
        CompoundNBT tag = blueprint.func_77978_p();
        BlockPos anchor = BlockPos.field_177992_a;
        PlacementSettings settings = SchematicItem.getSettings(blueprint);
        this.transformation = new SchematicTransformation();
        this.deployed = tag.func_74767_n("Deployed");
        if (this.deployed) {
            anchor = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("Anchor"));
        }
        BlockPos size = NBTUtil.func_186861_c((CompoundNBT)tag.func_74775_l("Bounds"));
        this.bounds = new AxisAlignedBB(BlockPos.field_177992_a, size);
        this.outline = new AABBOutline(this.bounds);
        this.outline.getParams().colored(6850245).lineWidth(0.0625f);
        this.transformation.init(anchor, settings, this.bounds);
    }

    public void deploy() {
        if (!this.deployed) {
            List<Tools> tools = Tools.getTools(Minecraft.func_71410_x().field_71439_g.func_184812_l_());
            this.selectionScreen = new ToolSelectionScreen(tools, this::equip);
        }
        this.deployed = true;
        this.setupRenderer();
    }

    public String getCurrentSchematicName() {
        return this.displayedSchematic != null ? this.displayedSchematic : "-";
    }

    public void printInstantly() {
        AllPackets.channel.sendToServer((Object)new SchematicPlacePacket(this.activeSchematicItem.func_77946_l()));
        CompoundNBT nbt = this.activeSchematicItem.func_77978_p();
        nbt.func_74757_a("Deployed", false);
        this.activeSchematicItem.func_77982_d(nbt);
        this.renderers.forEach(r -> r.setActive(false));
        this.active = false;
        this.markDirty();
    }

    public boolean isActive() {
        return this.active;
    }

    public AxisAlignedBB getBounds() {
        return this.bounds;
    }

    public SchematicTransformation getTransformation() {
        return this.transformation;
    }

    public boolean isDeployed() {
        return this.deployed;
    }

    public ItemStack getActiveSchematicItem() {
        return this.activeSchematicItem;
    }

    public AABBOutline getOutline() {
        return this.outline;
    }
}

