/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.advancement;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.curiosities.zapper.blockzapper.BlockzapperItem;
import com.simibubi.create.foundation.advancement.AllTriggers;
import com.simibubi.create.foundation.advancement.KineticBlockTrigger;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.PlacedBlockTrigger;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AllAdvancements
implements IDataProvider {
    static final String LANG = "advancement.create.";
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public void register(Consumer<Advancement> t) {
        String id = "create";
        Advancement root = Advancement.Builder.func_200278_a().func_215092_a(AllItems.BRASS_HAND.asStack(), (ITextComponent)new TranslationTextComponent("advancement.create.root", new Object[0]), (ITextComponent)new TranslationTextComponent("advancement.create.root.desc", new Object[0]), new ResourceLocation("create", "textures/block/palettes/gabbro/bricks.png"), FrameType.TASK, false, false, false).func_200275_a("0", (ICriterionInstance)InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[0])).func_203904_a(t, id + ":root");
        Advancement andesite_alloy = this.advancement("andesite_alloy", (IItemProvider)AllItems.ANDESITE_ALLOY.get(), TaskType.NORMAL).func_203905_a(root).func_200275_a("0", (ICriterionInstance)this.itemGathered((IItemProvider)AllItems.ANDESITE_ALLOY.get())).func_203904_a(t, id + ":andesite_alloy");
        this.kineticsBranch(t, andesite_alloy);
        Advancement water_wheel = this.advancement("water_wheel", (IItemProvider)AllBlocks.WATER_WHEEL.get(), TaskType.NORMAL).func_203905_a(andesite_alloy).func_200275_a("0", (ICriterionInstance)this.placeBlock((Block)AllBlocks.WATER_WHEEL.get())).func_200275_a("1", (ICriterionInstance)AllTriggers.WATER_WHEEL.instance()).func_203904_a(t, id + ":water_wheel");
        Advancement lava_wheel = this.advancement("lava_wheel", (IItemProvider)Items.field_151129_at, TaskType.SECRET).func_203905_a(water_wheel).func_200275_a("0", (ICriterionInstance)AllTriggers.LAVA_WHEEL.instance()).func_203904_a(t, id + ":lava_wheel");
        Advancement millstone = this.kinecticAdvancement("millstone", (Block)AllBlocks.MILLSTONE.get(), TaskType.NORMAL).func_203905_a(andesite_alloy).func_203904_a(t, id + ":millstone");
        Advancement andesite_casing = this.advancement("andesite_casing", (IItemProvider)AllBlocks.ANDESITE_CASING.get(), TaskType.GOAL).func_203905_a(andesite_alloy).func_200275_a("0", (ICriterionInstance)this.itemGathered((IItemProvider)AllBlocks.ANDESITE_CASING.get())).func_203904_a(t, id + ":andesite_casing");
        this.andesiteExpertLane(t, andesite_casing);
        Advancement drill = this.kinecticAdvancement("mechanical_drill", (Block)AllBlocks.MECHANICAL_DRILL.get(), TaskType.NORMAL).func_203905_a(andesite_casing).func_203904_a(t, id + ":mechanical_drill");
        Advancement press = this.advancement("press", (IItemProvider)AllBlocks.MECHANICAL_PRESS.get(), TaskType.MILESTONE).func_203905_a(andesite_casing).func_200275_a("0", (ICriterionInstance)AllTriggers.BONK.instance()).func_203904_a(t, id + ":press");
        Advancement rose_quartz = this.itemAdvancement("polished_rose_quartz", AllItems.POLISHED_ROSE_QUARTZ, TaskType.NORMAL).func_203905_a(andesite_casing).func_203904_a(t, id + ":polished_rose_quartz");
        Advancement electron_tube = this.itemAdvancement("electron_tube", AllItems.ELECTRON_TUBE, TaskType.NORMAL).func_203905_a(rose_quartz).func_203904_a(t, id + ":electron_tube");
        Advancement saw = this.kinecticAdvancement("mechanical_saw", (Block)AllBlocks.MECHANICAL_SAW.get(), TaskType.NORMAL).func_203905_a(press).func_203904_a(t, id + ":mechanical_saw");
        Advancement basin = this.advancement("basin", (IItemProvider)AllBlocks.BASIN.get(), TaskType.NORMAL).func_203905_a(press).func_200275_a("0", (ICriterionInstance)this.placeBlock((Block)AllBlocks.BASIN.get())).func_200275_a("1", (ICriterionInstance)AllTriggers.BASIN_THROW.instance()).func_203904_a(t, id + ":basin");
        Advancement mixer = this.advancement("mixer", (IItemProvider)AllBlocks.MECHANICAL_MIXER.get(), TaskType.MILESTONE).func_200275_a("0", (ICriterionInstance)this.placeBlock((Block)AllBlocks.MECHANICAL_MIXER.get())).func_200275_a("1", (ICriterionInstance)this.isPowered((Block)AllBlocks.MECHANICAL_MIXER.get())).func_200275_a("2", (ICriterionInstance)AllTriggers.MIXER_MIX.instance()).func_203905_a(basin).func_203904_a(t, id + ":mixer");
        Advancement compact = this.advancement("compact", (IItemProvider)Blocks.field_150339_S, TaskType.NORMAL).func_200275_a("0", (ICriterionInstance)AllTriggers.PRESS_COMPACT.instance()).func_203905_a(basin).func_203904_a(t, id + ":compact");
        Advancement brass = this.itemAdvancement("brass", AllItems.BRASS_INGOT, TaskType.NORMAL).func_203905_a(mixer).func_203904_a(t, id + ":brass");
        this.brassAge(t, brass);
        this.copperAge(t, press);
    }

    void kineticsBranch(Consumer<Advancement> t, Advancement root) {
        String id = "create";
        Advancement its_alive = this.advancement("its_alive", (IItemProvider)AllBlocks.COGWHEEL.get(), TaskType.NORMAL).func_203905_a(root).func_200275_a("0", (ICriterionInstance)AllTriggers.ROTATION.instance()).func_203904_a(t, id + ":its_alive");
        Advancement belt = this.advancement("belt", (IItemProvider)AllItems.BELT_CONNECTOR.get(), TaskType.NORMAL).func_203905_a(its_alive).func_200275_a("0", (ICriterionInstance)AllTriggers.CONNECT_BELT.instance()).func_203904_a(t, id + ":belt");
        Advancement wrench = this.itemAdvancement("wrench", AllItems.WRENCH, TaskType.NORMAL).func_203905_a(its_alive).func_203904_a(t, id + ":wrench");
        Advancement goggles = this.itemAdvancement("goggles", AllItems.GOGGLES, TaskType.NORMAL).func_203905_a(its_alive).func_203904_a(t, id + ":goggles");
        Advancement speed_gauge = this.kinecticAdvancement("speedometer", (Block)AllBlocks.SPEEDOMETER.get(), TaskType.NORMAL).func_203905_a(goggles).func_203904_a(t, id + ":speedometer");
        Advancement stress_gauge = this.kinecticAdvancement("stressometer", (Block)AllBlocks.STRESSOMETER.get(), TaskType.NORMAL).func_203905_a(goggles).func_203904_a(t, id + ":stressometer");
        Advancement shifting_gears = this.advancement("shifting_gears", (IItemProvider)AllBlocks.LARGE_COGWHEEL.get(), TaskType.NORMAL).func_203905_a(its_alive).func_200275_a("0", (ICriterionInstance)AllTriggers.SHIFTING_GEARS.instance()).func_203904_a(t, id + ":shifting_gears");
        Advancement overstressed = this.advancement("overstressed", (IItemProvider)Items.field_221803_eL, TaskType.SECRET).func_203905_a(its_alive).func_200275_a("0", (ICriterionInstance)AllTriggers.OVERSTRESSED.instance()).func_203904_a(t, id + ":overstressed");
    }

    void copperAge(Consumer<Advancement> t, Advancement root) {
        String id = "create";
        Advancement copper_casing = this.advancement("copper_casing", (IItemProvider)AllBlocks.COPPER_CASING.get(), TaskType.GOAL).func_203905_a(root).func_200275_a("0", (ICriterionInstance)this.itemGathered((IItemProvider)AllBlocks.COPPER_CASING.get())).func_203904_a(t, id + ":copper_casing");
        Advancement copper_end = this.deadEnd().func_203905_a(copper_casing).func_200275_a("0", (ICriterionInstance)this.itemGathered((IItemProvider)AllBlocks.COPPER_CASING.get())).func_203904_a(t, id + ":copper_end");
    }

    void brassAge(Consumer<Advancement> t, Advancement root) {
        String id = "create";
        Advancement brass_casing = this.advancement("brass_casing", (IItemProvider)AllBlocks.BRASS_CASING.get(), TaskType.GOAL).func_203905_a(root).func_200275_a("0", (ICriterionInstance)this.itemGathered((IItemProvider)AllBlocks.BRASS_CASING.get())).func_203904_a(t, id + ":brass_casing");
        Advancement crafter = this.kinecticAdvancement("crafter", (Block)AllBlocks.MECHANICAL_CRAFTER.get(), TaskType.MILESTONE).func_203905_a(brass_casing).func_203904_a(t, id + ":crafter");
        Advancement extendo_grip = this.advancement("extendo_grip", (IItemProvider)AllItems.EXTENDO_GRIP.get(), TaskType.NORMAL).func_203905_a(root).func_200275_a("0", (ICriterionInstance)AllTriggers.EXTENDO.instance()).func_203904_a(t, id + ":extendo_grip");
        Advancement dual_extendo_grip = this.advancement("dual_extendo_grip", (IItemProvider)AllItems.EXTENDO_GRIP.get(), TaskType.SECRET).func_203905_a(extendo_grip).func_200275_a("0", (ICriterionInstance)AllTriggers.GIGA_EXTENDO.instance()).func_203904_a(t, id + ":dual_extendo_grip");
        Advancement deployer = this.kinecticAdvancement("deployer", (Block)AllBlocks.DEPLOYER.get(), TaskType.GOAL).func_203905_a(brass_casing).func_203904_a(t, id + ":deployer");
        Advancement fist_bump = this.advancement("fist_bump", (IItemProvider)AllBlocks.DEPLOYER.get(), TaskType.SECRET).func_203905_a(deployer).func_200275_a("0", (ICriterionInstance)AllTriggers.DEPLOYER_BOOP.instance()).func_203904_a(t, id + ":fist_bump");
        Advancement crushing_wheel = this.advancement("crushing_wheel", (IItemProvider)AllBlocks.CRUSHING_WHEEL.get(), TaskType.MILESTONE).func_203905_a(crafter).func_200275_a("0", (ICriterionInstance)this.itemGathered((IItemProvider)AllBlocks.CRUSHING_WHEEL.get())).func_203904_a(t, id + ":crushing_wheel");
        Advancement chromatic_compound = this.itemAdvancement("chromatic_compound", AllItems.CHROMATIC_COMPOUND, TaskType.NORMAL).func_203905_a(crushing_wheel).func_203904_a(t, id + ":chromatic_compound");
        Advancement shadow_steel = this.itemAdvancement("shadow_steel", AllItems.SHADOW_STEEL, TaskType.GOAL).func_203905_a(chromatic_compound).func_203904_a(t, id + ":shadow_steel");
        Advancement refined_radiance = this.itemAdvancement("refined_radiance", AllItems.REFINED_RADIANCE, TaskType.GOAL).func_203905_a(chromatic_compound).func_203904_a(t, id + ":refined_radiance");
        Advancement deforester = this.itemAdvancement("deforester", AllItems.DEFORESTER, TaskType.NORMAL).func_203905_a(refined_radiance).func_203904_a(t, id + ":deforester");
        Advancement zapper = this.itemAdvancement("zapper", AllItems.BLOCKZAPPER, TaskType.NORMAL).func_203905_a(refined_radiance).func_203904_a(t, id + ":zapper");
        ItemStack gunWithPurpurStuff = AllItems.BLOCKZAPPER.asStack();
        for (BlockzapperItem.Components c : BlockzapperItem.Components.values()) {
            BlockzapperItem.setTier(c, BlockzapperItem.ComponentTier.Chromatic, gunWithPurpurStuff);
        }
        Advancement upgraded_zapper = this.advancement("upgraded_zapper", gunWithPurpurStuff, TaskType.CHALLENGE).func_200275_a("0", (ICriterionInstance)AllTriggers.UPGRADED_ZAPPER.instance()).func_203905_a(zapper).func_203904_a(t, id + ":upgraded_zapper");
        Advancement symmetry_wand = this.itemAdvancement("wand_of_symmetry", AllItems.WAND_OF_SYMMETRY, TaskType.NORMAL).func_203905_a(refined_radiance).func_203904_a(t, id + ":wand_of_symmetry");
        Advancement shadow_end = this.deadEnd().func_203905_a(shadow_steel).func_200275_a("0", (ICriterionInstance)this.itemGathered((IItemProvider)AllItems.SHADOW_STEEL.get())).func_203904_a(t, id + ":shadow_end");
    }

    private void andesiteExpertLane(Consumer<Advancement> t, Advancement root) {
        String id = "create";
    }

    public AllAdvancements(DataGenerator generatorIn) {
        this.generator = generatorIn;
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = p_204017_3_ -> {
            if (!set.add(p_204017_3_.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + p_204017_3_.func_192067_g());
            }
            Path path1 = AllAdvancements.getPath(path, p_204017_3_);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)p_204017_3_.func_192075_a().func_200273_b(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        this.register(consumer);
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.func_192067_g().func_110624_b() + "/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }

    public String func_200397_b() {
        return "CreateAdvancements";
    }

    public PlacedBlockTrigger.Instance placeBlock(Block block) {
        return PlacedBlockTrigger.Instance.func_203934_a((Block)block);
    }

    public KineticBlockTrigger.Instance isPowered(Block block) {
        return AllTriggers.KINETIC_BLOCK.forBlock(block);
    }

    public InventoryChangeTrigger.Instance itemGathered(IItemProvider itemprovider) {
        return InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])new IItemProvider[]{itemprovider});
    }

    public Advancement.Builder kinecticAdvancement(String name, Block block, TaskType type) {
        return this.advancement(name, (IItemProvider)block, type).func_200275_a("0", (ICriterionInstance)this.placeBlock(block)).func_200275_a("1", (ICriterionInstance)this.isPowered(block));
    }

    public Advancement.Builder advancement(String name, IItemProvider icon, TaskType type) {
        return this.advancement(name, new ItemStack(icon), type);
    }

    public Advancement.Builder deadEnd() {
        return this.advancement("eob", (IItemProvider)Items.field_221592_t, TaskType.SILENT_GATE);
    }

    public Advancement.Builder advancement(String name, ItemStack icon, TaskType type) {
        return Advancement.Builder.func_200278_a().func_215092_a(icon, (ITextComponent)new TranslationTextComponent(LANG + name, new Object[0]), (ITextComponent)new TranslationTextComponent(LANG + name + ".desc", new Object[0]), null, type.frame, type.toast, type.announce, type.hide);
    }

    public Advancement.Builder itemAdvancement(String name, Supplier<? extends Item> item, TaskType type) {
        return this.advancement(name, (IItemProvider)item.get(), type).func_200275_a("0", (ICriterionInstance)this.itemGathered((IItemProvider)item.get()));
    }

    static enum TaskType {
        NORMAL(FrameType.TASK, true, false, false),
        MILESTONE(FrameType.TASK, true, true, false),
        GOAL(FrameType.GOAL, true, true, false),
        SECRET(FrameType.GOAL, true, true, true),
        SILENT_GATE(FrameType.CHALLENGE, false, false, false),
        CHALLENGE(FrameType.CHALLENGE, true, true, false);

        private FrameType frame;
        private boolean toast;
        private boolean announce;
        private boolean hide;

        private TaskType(FrameType frame, boolean toast, boolean announce, boolean hide) {
            this.frame = frame;
            this.toast = toast;
            this.announce = announce;
            this.hide = hide;
        }
    }
}

