/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.base.CasingBlock;
import com.simibubi.create.content.contraptions.components.structureMovement.piston.MechanicalPistonGenerator;
import com.simibubi.create.content.logistics.block.inventories.CrateBlock;
import com.simibubi.create.foundation.block.connected.CTSpriteShiftEntry;
import com.simibubi.create.foundation.block.connected.StandardCTBehaviour;
import com.simibubi.create.foundation.config.StressConfigDefaults;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.foundation.data.ModelGen;
import com.simibubi.create.foundation.data.SharedProperties;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import com.simibubi.create.repack.registrate.util.nullness.NonNullUnaryOperator;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.PistonType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;

public class BuilderTransformers {
    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> cuckooClock() {
        return b -> (BlockBuilder)((BlockBuilder)b.initialProperties(SharedProperties::wooden).blockstate((c, p) -> p.horizontalBlock((Block)c.get(), (ModelFile)p.models().getExistingFile(p.modLoc("block/cuckoo_clock/block")))).addLayer(() -> RenderType::func_228641_d_).transform(StressConfigDefaults.setImpact(1.0))).item().transform(ModelGen.customItemModel("cuckoo_clock", "item"));
    }

    public static <B extends CasingBlock> NonNullUnaryOperator<BlockBuilder<B, CreateRegistrate>> casing(CTSpriteShiftEntry ct) {
        return b -> ((BlockBuilder)b.onRegister(CreateRegistrate.connectedTextures(new StandardCTBehaviour(ct)))).initialProperties(SharedProperties::stone).blockstate((c, p) -> p.simpleBlock((Block)c.get())).simpleItem();
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> mechanicalPiston(PistonType type) {
        return b -> (BlockBuilder)((BlockBuilder)b.initialProperties(SharedProperties::stone).properties(p -> p.func_226896_b_()).blockstate(new MechanicalPistonGenerator(type)::generate).addLayer(() -> RenderType::func_228641_d_).transform(StressConfigDefaults.setImpact(4.0))).item().transform(ModelGen.customItemModel("mechanical_piston", type.func_176610_l(), "item"));
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> bearing(String prefix, String backTexture) {
        ResourceLocation baseBlockModelLocation = Create.asResource("block/bearing/block");
        ResourceLocation baseItemModelLocation = Create.asResource("block/bearing/item");
        ResourceLocation sideTextureLocation = Create.asResource("block/" + prefix + "_bearing_side");
        ResourceLocation backTextureLocation = Create.asResource("block/" + backTexture);
        return b -> (BlockBuilder)b.initialProperties(SharedProperties::stone).properties(p -> p.func_226896_b_()).blockstate((c, p) -> p.directionalBlock((Block)c.get(), (ModelFile)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent(c.getName(), baseBlockModelLocation)).texture("side", sideTextureLocation)).texture("back", backTextureLocation))).item().model((c, p) -> {
            ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)p.withExistingParent(c.getName(), baseItemModelLocation)).texture("side", sideTextureLocation)).texture("back", backTextureLocation);
        }).build();
    }

    public static <B extends Block, P> NonNullUnaryOperator<BlockBuilder<B, P>> crate(String type) {
        return b -> (BlockBuilder)b.initialProperties(SharedProperties::stone).blockstate((c, p) -> {
            String[] variants = new String[]{"single", "top", "bottom", "left", "right"};
            HashMap<String, ModelBuilder> models = new HashMap<String, ModelBuilder>();
            ResourceLocation crate = p.modLoc("block/crate_" + type);
            ResourceLocation side = p.modLoc("block/crate_" + type + "_side");
            ResourceLocation casing = p.modLoc("block/" + type + "_casing");
            for (String variant : variants) {
                models.put(variant, ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)p.models().withExistingParent("block/crate/" + type + "/" + variant, p.modLoc("block/crate/" + variant))).texture("crate", crate)).texture("side", side)).texture("casing", casing));
            }
            p.getVariantBuilder((Block)c.get()).forAllStates(state -> {
                String variant = "single";
                int yRot = 0;
                if (((Boolean)state.func_177229_b((IProperty)CrateBlock.DOUBLE)).booleanValue()) {
                    Direction direction = (Direction)state.func_177229_b((IProperty)CrateBlock.field_176387_N);
                    if (direction.func_176740_k() == Direction.Axis.X) {
                        yRot = 90;
                    }
                    switch (direction) {
                        case DOWN: {
                            variant = "top";
                            break;
                        }
                        case NORTH: 
                        case EAST: {
                            variant = "right";
                            break;
                        }
                        case UP: {
                            variant = "bottom";
                            break;
                        }
                        default: {
                            variant = "left";
                        }
                    }
                }
                return ConfiguredModel.builder().modelFile((ModelFile)models.get(variant)).rotationY(yRot).build();
            });
        }).item().transform(ModelGen.customItemModel("crate", type, "single"));
    }
}

