/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.data.AllLangPartials;
import com.simibubi.create.foundation.utility.FilesHelper;
import com.simibubi.create.foundation.utility.Lang;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.JSONUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.lang3.text.translate.JavaUnicodeEscaper;

public class LangMerger
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    static final String CATEGORY_HEADER = "\t\"_\": \"->------------------------]  %s  [------------------------<-\",";
    private DataGenerator gen;
    private List<Object> data;

    public LangMerger(DataGenerator gen) {
        this.gen = gen;
        this.data = new ArrayList<Object>();
    }

    public String func_200397_b() {
        return "Lang merger";
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        Path path = this.gen.func_200391_b().resolve("assets/create/lang/en_us.json");
        this.collectExistingEntries(path);
        this.collectEntries();
        if (this.data.isEmpty()) {
            return;
        }
        this.save(cache, path);
    }

    private void collectExistingEntries(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            Create.logger.warn("Nothing to merge! It appears no lang was generated before me.");
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(path);){
            JsonObject jsonobject = (JsonObject)JSONUtils.func_193839_a((Gson)GSON, (Reader)reader, JsonObject.class);
            this.addAll("Game Elements", jsonobject);
            reader.close();
        }
    }

    protected void addAll(String header, JsonObject jsonobject) {
        if (jsonobject == null) {
            return;
        }
        header = String.format(CATEGORY_HEADER, header);
        this.data.add("\n");
        this.data.add(header);
        this.data.add("\n\n");
        MutableObject previousKey = new MutableObject((Object)"");
        jsonobject.entrySet().stream().forEachOrdered(entry -> {
            String key = (String)entry.getKey();
            String value = ((JsonElement)entry.getValue()).getAsString();
            if (!((String)previousKey.getValue()).isEmpty() && this.shouldAddLineBreak(key, (String)previousKey.getValue())) {
                this.data.add("\n");
            }
            this.data.add(new LangEntry(key, value));
            previousKey.setValue((Object)key);
        });
        this.data.add("\n");
    }

    protected boolean shouldAddLineBreak(String key, String previousKey) {
        if (key.endsWith(".tooltip")) {
            return true;
        }
        key = new String(key).replaceFirst("\\.", "");
        previousKey = new String(previousKey).replaceFirst("\\.", "");
        String[] split = key.split("\\.");
        String[] split2 = previousKey.split("\\.");
        if (split.length == 0 || split2.length == 0) {
            return false;
        }
        return !split[0].equals(split2[0]);
    }

    private void collectEntries() {
        for (AllLangPartials partial : AllLangPartials.values()) {
            String fileName = Lang.asId(partial.name());
            String filepath = "assets/create/lang/default/" + fileName + ".json";
            JsonElement element = FilesHelper.loadJsonResource(filepath);
            if (element == null) {
                throw new IllegalStateException(String.format("Could not find default lang file: %s", filepath));
            }
            this.addAll(partial.getDisplay(), element.getAsJsonObject());
        }
    }

    private void save(DirectoryCache cache, Path target) throws IOException {
        String data = this.createString();
        data = JavaUnicodeEscaper.outsideOf((int)0, (int)127).translate((CharSequence)data);
        String hash = IDataProvider.field_208307_a.hashUnencodedChars((CharSequence)data).toString();
        if (!Objects.equals(cache.func_208323_a(target), hash) || !Files.exists(target, new LinkOption[0])) {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(target, new OpenOption[0]);){
                bufferedwriter.write(data);
                bufferedwriter.close();
            }
        }
        cache.func_208316_a(target, hash);
    }

    protected String createString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\n");
        this.data.forEach(builder::append);
        builder.append("\t\"_\": \"Thank you for translating Create!\"\n\n");
        builder.append("}");
        return builder.toString();
    }

    private class LangEntry {
        static final String ENTRY_FORMAT = "\t\"%s\": \"%s\",\n";
        private String key;
        private String value;

        LangEntry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String toString() {
            return String.format(ENTRY_FORMAT, this.key, this.value);
        }
    }
}

