/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity;

import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.IBehaviourType;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;

public abstract class TileEntityBehaviour {
    public SmartTileEntity tileEntity;
    private boolean paused;
    private int lazyTickRate;
    private int lazyTickCounter;

    public TileEntityBehaviour(SmartTileEntity te) {
        this.tileEntity = te;
        this.paused = false;
        this.setLazyTickRate(10);
    }

    public abstract IBehaviourType<?> getType();

    public void initialize() {
    }

    public void tick() {
        if (this.lazyTickCounter-- <= 0) {
            this.lazyTickCounter = this.lazyTickRate;
            this.lazyTick();
        }
    }

    public void readNBT(CompoundNBT nbt) {
    }

    public void updateClient(CompoundNBT nbt) {
    }

    public void writeNBT(CompoundNBT nbt) {
    }

    public void onBlockChanged(BlockState oldState) {
    }

    public void onNeighborChanged(Direction direction) {
    }

    public void remove() {
    }

    public void destroy() {
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void setLazyTickRate(int slowTickRate) {
        this.lazyTickRate = slowTickRate;
        this.lazyTickCounter = slowTickRate;
    }

    public void lazyTick() {
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public BlockPos getPos() {
        return this.tileEntity.func_174877_v();
    }

    public World getWorld() {
        return this.tileEntity.func_145831_w();
    }

    public static <T extends TileEntityBehaviour> T get(ILightReader reader, BlockPos pos, IBehaviourType<T> type) {
        return TileEntityBehaviour.get(reader.func_175625_s(pos), type);
    }

    public static <T extends TileEntityBehaviour> void destroy(ILightReader reader, BlockPos pos, IBehaviourType<T> type) {
        T behaviour = TileEntityBehaviour.get(reader.func_175625_s(pos), type);
        if (behaviour != null) {
            ((TileEntityBehaviour)behaviour).destroy();
        }
    }

    public static <T extends TileEntityBehaviour> T get(TileEntity te, IBehaviourType<T> type) {
        if (te == null) {
            return null;
        }
        if (!(te instanceof SmartTileEntity)) {
            return null;
        }
        SmartTileEntity ste = (SmartTileEntity)te;
        return ste.getBehaviour(type);
    }

    public CompoundNBT writeToClient(CompoundNBT compound) {
        return compound;
    }
}

