/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.edgeInteraction;

import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.IBehaviourType;
import java.util.Optional;
import net.minecraft.item.Item;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EdgeInteractionBehaviour
extends TileEntityBehaviour {
    public static IBehaviourType<EdgeInteractionBehaviour> TYPE = new IBehaviourType<EdgeInteractionBehaviour>(){};
    ConnectionCallback connectionCallback;
    ConnectivityPredicate connectivityPredicate;
    Optional<Item> requiredItem;

    public EdgeInteractionBehaviour(SmartTileEntity te, ConnectionCallback callback) {
        super(te);
        this.connectionCallback = callback;
        this.requiredItem = Optional.empty();
        this.connectivityPredicate = (world, pos, face, face2) -> true;
    }

    public EdgeInteractionBehaviour connectivity(ConnectivityPredicate pred) {
        this.connectivityPredicate = pred;
        return this;
    }

    public EdgeInteractionBehaviour require(Item item) {
        this.requiredItem = Optional.of(item);
        return this;
    }

    @Override
    public IBehaviourType<?> getType() {
        return TYPE;
    }

    @FunctionalInterface
    public static interface ConnectivityPredicate {
        public boolean test(World var1, BlockPos var2, Direction var3, Direction var4);
    }

    @FunctionalInterface
    public static interface ConnectionCallback {
        public void apply(World var1, BlockPos var2, BlockPos var3);
    }
}

