/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.filtering;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.AllSpecialTextures;
import com.simibubi.create.CreateClient;
import com.simibubi.create.content.logistics.item.filter.FilterItem;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBox;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxRenderer;
import com.simibubi.create.foundation.tileEntity.behaviour.filtering.FilteringBehaviour;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILightReader;

public class FilteringRenderer {
    public static void tick() {
        Minecraft mc = Minecraft.func_71410_x();
        RayTraceResult target = mc.field_71476_x;
        if (target == null || !(target instanceof BlockRayTraceResult)) {
            return;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)target;
        ClientWorld world = mc.field_71441_e;
        BlockPos pos = result.func_216350_a();
        BlockState state = world.func_180495_p(pos);
        FilteringBehaviour behaviour = TileEntityBehaviour.get((ILightReader)world, pos, FilteringBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        if (!behaviour.isActive()) {
            return;
        }
        if (mc.field_71439_g.func_225608_bj_()) {
            return;
        }
        if (!behaviour.slotPositioning.shouldRender(state)) {
            return;
        }
        ItemStack filter = behaviour.getFilter();
        boolean isFilterSlotted = filter.func_77973_b() instanceof FilterItem;
        boolean showCount = behaviour.isCountVisible();
        String label = isFilterSlotted ? "" : Lang.translate("logistics.filter", new Object[0]);
        boolean hit = behaviour.slotPositioning.testHit(state, target.func_216347_e().func_178788_d(new Vec3d((Vec3i)pos)));
        AxisAlignedBB emptyBB = new AxisAlignedBB(Vec3d.field_186680_a, Vec3d.field_186680_a);
        AxisAlignedBB bb = isFilterSlotted ? emptyBB.func_72314_b((double)0.45f, (double)0.31f, (double)0.2f) : emptyBB.func_186662_g(0.25);
        ValueBox box = showCount ? new ValueBox.ItemValueBox(label, bb, pos, filter, behaviour.scrollableValue) : new ValueBox(label, bb, pos);
        box.offsetLabel(behaviour.textShift).withColors(8022572, 12033380).scrollTooltip(showCount ? "[" + Lang.translate("action.scroll", new Object[0]) + "]" : "").passive(!hit);
        CreateClient.outliner.showValueBox(pos, box.transform(behaviour.slotPositioning)).lineWidth(0.015625f).withFaceTexture(hit ? AllSpecialTextures.THIN_CHECKERED : null).highlightFace(result.func_216354_b());
    }

    public static void renderOnTileEntity(SmartTileEntity tileEntityIn, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        if (tileEntityIn == null || tileEntityIn.func_145837_r()) {
            return;
        }
        FilteringBehaviour behaviour = TileEntityBehaviour.get(tileEntityIn, FilteringBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        if (!behaviour.isActive()) {
            return;
        }
        if (behaviour.getFilter().func_190926_b()) {
            return;
        }
        ms.func_227860_a_();
        behaviour.slotPositioning.transform(tileEntityIn.func_195044_w(), ms);
        ValueBoxRenderer.renderItemIntoValueBox(behaviour.getFilter(), ms, buffer, light, overlay);
        ms.func_227865_b_();
    }
}

