/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.inventory;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.IBehaviourType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;

public class InventoryManagementBehaviour
extends TileEntityBehaviour {
    Map<Pair<BlockPos, Direction>, LazyOptional<IItemHandler>> inventories;
    private Supplier<List<Pair<BlockPos, Direction>>> attachments;
    private List<IItemHandler> activeHandlers;
    public static IBehaviourType<InventoryManagementBehaviour> TYPE = new IBehaviourType<InventoryManagementBehaviour>(){};

    public InventoryManagementBehaviour(SmartTileEntity te, Supplier<List<Pair<BlockPos, Direction>>> attachments) {
        super(te);
        this.attachments = attachments;
        this.setLazyTickRate(20);
        this.activeHandlers = new ArrayList<IItemHandler>();
        this.inventories = new HashMap<Pair<BlockPos, Direction>, LazyOptional<IItemHandler>>();
    }

    @Override
    public void initialize() {
        super.initialize();
        this.attachments.get().forEach(offset -> this.inventories.put((Pair<BlockPos, Direction>)offset, this.findInventory((Pair<BlockPos, Direction>)offset)));
        this.lazyTick();
    }

    @Override
    public void lazyTick() {
        super.lazyTick();
        this.activeHandlers.clear();
        for (Pair<BlockPos, Direction> pair : this.inventories.keySet()) {
            LazyOptional<IItemHandler> lazyOptional = this.inventories.get(pair);
            if (lazyOptional.isPresent()) {
                this.activeHandlers.add((IItemHandler)lazyOptional.orElse(null));
                continue;
            }
            lazyOptional = this.findInventory(pair);
            if (lazyOptional.isPresent()) {
                this.activeHandlers.add((IItemHandler)lazyOptional.orElse(null));
            }
            this.inventories.put(pair, lazyOptional);
        }
    }

    public List<IItemHandler> getInventories() {
        return this.activeHandlers;
    }

    public IItemHandler getInventory() {
        if (this.activeHandlers.isEmpty()) {
            return null;
        }
        return this.activeHandlers.get(0);
    }

    protected LazyOptional<IItemHandler> findInventory(Pair<BlockPos, Direction> offset) {
        BlockPos invPos = this.tileEntity.func_174877_v().func_177971_a((Vec3i)offset.getKey());
        World world = this.getWorld();
        if (!world.func_195588_v(invPos)) {
            return LazyOptional.empty();
        }
        BlockState invState = world.func_180495_p(invPos);
        if (!invState.hasTileEntity()) {
            return LazyOptional.empty();
        }
        TileEntity invTE = world.func_175625_s(invPos);
        if (invTE == null) {
            return LazyOptional.empty();
        }
        LazyOptional inventory = invTE.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, (Direction)offset.getValue());
        if (inventory == null) {
            return LazyOptional.empty();
        }
        return inventory;
    }

    @Override
    public IBehaviourType<?> getType() {
        return TYPE;
    }

    public static class Attachments {
        public static final Supplier<List<Pair<BlockPos, Direction>>> toward(Supplier<Direction> facing) {
            return () -> ImmutableList.of((Object)Pair.of((Object)new BlockPos(((Direction)facing.get()).func_176730_m()), (Object)((Direction)facing.get()).func_176734_d()));
        }
    }
}

