/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.inventory;

import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.behaviour.IBehaviourType;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.AutoExtractingBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.InventoryManagementBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.SynchronizedExtraction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ILightReader;

public class SingleTargetAutoExtractingBehaviour
extends AutoExtractingBehaviour {
    public static IBehaviourType<SingleTargetAutoExtractingBehaviour> TYPE = new IBehaviourType<SingleTargetAutoExtractingBehaviour>(){};
    private Supplier<Direction> attachmentDirection;
    boolean synced;
    boolean advantageOnNextSync;

    public SingleTargetAutoExtractingBehaviour(SmartTileEntity te, Supplier<Direction> attachmentDirection, Consumer<ItemStack> onExtract, int delay) {
        super(te, InventoryManagementBehaviour.Attachments.toward(attachmentDirection), onExtract, delay);
        this.attachmentDirection = attachmentDirection;
        this.synced = true;
        this.advantageOnNextSync = false;
    }

    public SingleTargetAutoExtractingBehaviour setSynchronized(boolean sync) {
        this.synced = sync;
        return this;
    }

    @Override
    public void writeNBT(CompoundNBT nbt) {
        nbt.func_74757_a("Advantage", this.advantageOnNextSync);
        super.writeNBT(nbt);
    }

    @Override
    public void readNBT(CompoundNBT nbt) {
        this.advantageOnNextSync = nbt.func_74767_n("Advantage");
        super.readNBT(nbt);
    }

    @Override
    public boolean extract() {
        if (this.synced) {
            BlockPos invPos = this.tileEntity.func_174877_v().func_177972_a(this.attachmentDirection.get());
            return SynchronizedExtraction.extractSynchronized((ILightReader)this.getWorld(), invPos);
        }
        return this.extractFromInventory();
    }

    public boolean extractFromInventory() {
        return super.extract();
    }

    @Override
    public IBehaviourType<?> getType() {
        return TYPE;
    }
}

