/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.inventory;

import com.simibubi.create.content.logistics.block.inventories.CrateBlock;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.inventory.SingleTargetAutoExtractingBehaviour;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.ChestType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILightReader;

public class SynchronizedExtraction {
    static boolean extractSynchronized(ILightReader reader, BlockPos inventoryPos) {
        int startIndex;
        List<SingleTargetAutoExtractingBehaviour> actors = SynchronizedExtraction.getAllSyncedExtractors(reader, inventoryPos);
        boolean success = false;
        for (startIndex = actors.size() - 1; startIndex > 0 && !actors.get((int)startIndex).advantageOnNextSync; --startIndex) {
        }
        for (int i = 0; i < actors.size(); ++i) {
            success |= actors.get((startIndex + i) % actors.size()).extractFromInventory();
        }
        if (success) {
            actors.get((int)startIndex).advantageOnNextSync = false;
            actors.get((int)((startIndex + 1) % actors.size())).advantageOnNextSync = true;
        }
        return success;
    }

    private static List<SingleTargetAutoExtractingBehaviour> getAllSyncedExtractors(ILightReader reader, BlockPos inventoryPos) {
        ArrayList<SingleTargetAutoExtractingBehaviour> list = new ArrayList<SingleTargetAutoExtractingBehaviour>();
        ArrayList<BlockPos> inventoryPositions = new ArrayList<BlockPos>();
        inventoryPositions.add(inventoryPos);
        BlockState blockState = reader.func_180495_p(inventoryPos);
        if (blockState.func_177230_c() instanceof ChestBlock && blockState.func_177229_b((IProperty)ChestBlock.field_196314_b) != ChestType.SINGLE) {
            inventoryPositions.add(inventoryPos.func_177972_a(ChestBlock.func_196311_i((BlockState)blockState)));
        }
        if (blockState.func_177230_c() instanceof CrateBlock && ((Boolean)blockState.func_177229_b((IProperty)CrateBlock.DOUBLE)).booleanValue()) {
            inventoryPositions.add(inventoryPos.func_177972_a((Direction)blockState.func_177229_b((IProperty)CrateBlock.field_176387_N)));
        }
        for (BlockPos pos : inventoryPositions) {
            for (Direction direction : Direction.values()) {
                SingleTargetAutoExtractingBehaviour behaviour = TileEntityBehaviour.get(reader, pos.func_177972_a(direction), SingleTargetAutoExtractingBehaviour.TYPE);
                if (behaviour == null || !behaviour.synced || behaviour.getShouldPause().get().booleanValue() || !behaviour.getShouldExtract().get().booleanValue() || !behaviour.inventories.keySet().stream().anyMatch(p -> ((BlockPos)p.getKey()).func_177971_a((Vec3i)behaviour.getPos()).equals((Object)pos))) continue;
                list.add(behaviour);
            }
        }
        return list;
    }
}

