/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue;

import com.simibubi.create.AllItems;
import com.simibubi.create.AllKeys;
import com.simibubi.create.foundation.tileEntity.SmartTileEntity;
import com.simibubi.create.foundation.tileEntity.TileEntityBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.BulkScrollValueBehaviour;
import com.simibubi.create.foundation.tileEntity.behaviour.scrollvalue.ScrollValueBehaviour;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.ILightReader;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ScrollValueHandler {
    @OnlyIn(value=Dist.CLIENT)
    public static boolean onScroll(double delta) {
        RayTraceResult objectMouseOver = Minecraft.func_71410_x().field_71476_x;
        if (!(objectMouseOver instanceof BlockRayTraceResult)) {
            return false;
        }
        BlockRayTraceResult result = (BlockRayTraceResult)objectMouseOver;
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        BlockPos blockPos = result.func_216350_a();
        ScrollValueBehaviour scrolling = TileEntityBehaviour.get((ILightReader)world, blockPos, ScrollValueBehaviour.TYPE);
        if (scrolling == null) {
            return false;
        }
        if (!mc.field_71439_g.func_175142_cm()) {
            return false;
        }
        if (scrolling.needsWrench && !AllItems.WRENCH.isIn(mc.field_71439_g.func_184614_ca())) {
            return false;
        }
        if (scrolling.slotPositioning instanceof ValueBoxTransform.Sided) {
            ((ValueBoxTransform.Sided)scrolling.slotPositioning).fromSide(result.func_216354_b());
        }
        if (!scrolling.testHit(objectMouseOver.func_216347_e())) {
            return false;
        }
        if (scrolling instanceof BulkScrollValueBehaviour && AllKeys.ctrlDown()) {
            BulkScrollValueBehaviour bulkScrolling = (BulkScrollValueBehaviour)scrolling;
            for (SmartTileEntity smartTileEntity : bulkScrolling.getBulk()) {
                ScrollValueBehaviour other = TileEntityBehaviour.get(smartTileEntity, ScrollValueBehaviour.TYPE);
                if (other == null) continue;
                ScrollValueHandler.applyTo(delta, other);
            }
        } else {
            ScrollValueHandler.applyTo(delta, scrolling);
        }
        return true;
    }

    protected static void applyTo(double delta, ScrollValueBehaviour scrolling) {
        scrolling.ticksUntilScrollPacket = 10;
        int valueBefore = scrolling.scrollableValue;
        ScrollValueBehaviour.StepContext context = new ScrollValueBehaviour.StepContext();
        context.control = AllKeys.ctrlDown();
        context.shift = AllKeys.shiftDown();
        context.currentValue = scrolling.scrollableValue;
        context.forward = delta > 0.0;
        double newValue = (double)scrolling.scrollableValue + Math.signum(delta) * (double)scrolling.step.apply(context).intValue();
        scrolling.scrollableValue = (int)MathHelper.func_151237_a((double)newValue, (double)scrolling.min, (double)scrolling.max);
        if (valueBefore != scrolling.scrollableValue) {
            scrolling.clientCallback.accept(scrolling.scrollableValue);
        }
    }
}

