/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.SlabType;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockHelper {
    public static int findAndRemoveInInventory(BlockState block, PlayerEntity player, int amount) {
        int taken;
        boolean needsTwo;
        int amountFound = 0;
        Item required = BlockHelper.getRequiredItem(block).func_77973_b();
        boolean bl = needsTwo = block.func_196959_b((IProperty)BlockStateProperties.field_208145_at) && block.func_177229_b((IProperty)BlockStateProperties.field_208145_at) == SlabType.DOUBLE;
        if (needsTwo) {
            amount *= 2;
        }
        int preferredSlot = player.field_71071_by.field_70461_c;
        ItemStack itemstack = player.field_71071_by.func_70301_a(preferredSlot);
        int count = itemstack.func_190916_E();
        if (itemstack.func_77973_b() == required && count > 0) {
            taken = Math.min(count, amount - amountFound);
            player.field_71071_by.func_70299_a(preferredSlot, new ItemStack((IItemProvider)itemstack.func_77973_b(), count - taken));
            amountFound += taken;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_() && amountFound != amount; ++i) {
            itemstack = player.field_71071_by.func_70301_a(i);
            count = itemstack.func_190916_E();
            if (itemstack.func_77973_b() != required || count <= 0) continue;
            taken = Math.min(count, amount - amountFound);
            player.field_71071_by.func_70299_a(i, new ItemStack((IItemProvider)itemstack.func_77973_b(), count - taken));
            amountFound += taken;
        }
        if (needsTwo) {
            if (amountFound % 2 != 0) {
                player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)required));
            }
            amountFound /= 2;
        }
        return amountFound;
    }

    public static ItemStack getRequiredItem(BlockState state) {
        ItemStack itemStack = new ItemStack((IItemProvider)state.func_177230_c());
        return itemStack;
    }

    public static void destroyBlock(World world, BlockPos pos, float effectChance) {
        BlockHelper.destroyBlock(world, pos, effectChance, stack -> Block.func_180635_a((World)world, (BlockPos)pos, (ItemStack)stack));
    }

    public static void destroyBlock(World world, BlockPos pos, float effectChance, Consumer<ItemStack> droppedItemCallback) {
        TileEntity tileentity;
        IFluidState ifluidstate = world.func_204610_c(pos);
        BlockState state = world.func_180495_p(pos);
        if (world.field_73012_v.nextFloat() < effectChance) {
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
        }
        TileEntity tileEntity = tileentity = state.hasTileEntity() ? world.func_175625_s(pos) : null;
        if (world.func_82736_K().func_223586_b(GameRules.field_223603_f) && !world.restoringBlockSnapshots) {
            for (ItemStack itemStack : Block.func_220070_a((BlockState)state, (ServerWorld)((ServerWorld)world), (BlockPos)pos, (TileEntity)tileentity)) {
                droppedItemCallback.accept(itemStack);
            }
            state.func_215706_a(world, pos, ItemStack.field_190927_a);
        }
        world.func_175656_a(pos, ifluidstate.func_206883_i());
    }
}

