/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.utility.MatrixStacker;
import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.crash.ReportedException;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.ILightReader;
import net.minecraft.world.World;

public class TileEntityRenderHelper {
    public static void renderTileEntities(World world, Iterable<TileEntity> customRenderTEs, MatrixStack ms, MatrixStack localTransform, IRenderTypeBuffer buffer) {
        float pt = Minecraft.func_71410_x().func_184121_ak();
        Matrix4f matrix = localTransform.func_227866_c_().func_227870_a_();
        Iterator<TileEntity> iterator = customRenderTEs.iterator();
        while (iterator.hasNext()) {
            TileEntity tileEntity = iterator.next();
            TileEntityRenderer renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(tileEntity);
            if (renderer == null) {
                iterator.remove();
                continue;
            }
            try {
                BlockPos pos = tileEntity.func_174877_v();
                ms.func_227860_a_();
                MatrixStacker.of(ms).translate((Vec3i)pos);
                Vector4f vec = new Vector4f((float)pos.func_177958_n() + 0.5f, (float)pos.func_177956_o() + 0.5f, (float)pos.func_177952_p() + 0.5f, 1.0f);
                vec.func_229372_a_(matrix);
                BlockPos lightPos = new BlockPos((double)vec.func_195910_a(), (double)vec.func_195913_b(), (double)vec.func_195914_c());
                renderer.func_225616_a_(tileEntity, pt, ms, buffer, WorldRenderer.func_228421_a_((ILightReader)world, (BlockPos)lightPos), OverlayTexture.field_229196_a_);
                ms.func_227865_b_();
            }
            catch (ReportedException e) {
                if (((Boolean)AllConfigs.CLIENT.explainRenderErrors.get()).booleanValue()) {
                    Create.logger.error("TileEntity " + tileEntity.func_200662_C().getRegistryName().toString() + " didn't want to render while moved.\n", (Throwable)e);
                } else {
                    Create.logger.error("TileEntity " + tileEntity.func_200662_C().getRegistryName().toString() + " didn't want to render while moved.\n");
                }
                iterator.remove();
            }
        }
    }
}

