/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.simibubi.create.foundation.utility.VecHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.util.Direction;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import org.apache.commons.lang3.mutable.MutableObject;

public class VoxelShaper {
    private Map<Direction, VoxelShape> shapes = new HashMap<Direction, VoxelShape>();

    public VoxelShape get(Direction direction) {
        return this.shapes.get(direction);
    }

    public VoxelShape get(Direction.Axis axis) {
        return this.shapes.get(VoxelShaper.axisAsFace(axis));
    }

    public static VoxelShaper forHorizontal(VoxelShape shape, Direction facing) {
        return VoxelShaper.forDirectionsWithRotation(shape, facing, (Iterable<Direction>)Direction.Plane.HORIZONTAL, new HorizontalRotationValues());
    }

    public static VoxelShaper forHorizontalAxis(VoxelShape shape, Direction.Axis along) {
        return VoxelShaper.forDirectionsWithRotation(shape, VoxelShaper.axisAsFace(along), Arrays.asList(Direction.SOUTH, Direction.EAST), new HorizontalRotationValues());
    }

    public static VoxelShaper forDirectional(VoxelShape shape, Direction facing) {
        return VoxelShaper.forDirectionsWithRotation(shape, facing, Arrays.asList(Direction.values()), new DefaultRotationValues());
    }

    public static VoxelShaper forAxis(VoxelShape shape, Direction.Axis along) {
        return VoxelShaper.forDirectionsWithRotation(shape, VoxelShaper.axisAsFace(along), Arrays.asList(Direction.SOUTH, Direction.EAST, Direction.UP), new DefaultRotationValues());
    }

    public VoxelShaper withVerticalShapes(VoxelShape upShape) {
        this.shapes.put(Direction.UP, upShape);
        this.shapes.put(Direction.DOWN, VoxelShaper.rotatedCopy(upShape, new Vec3d(180.0, 0.0, 0.0)));
        return this;
    }

    public VoxelShaper withShape(VoxelShape shape, Direction facing) {
        this.shapes.put(facing, shape);
        return this;
    }

    public static Direction axisAsFace(Direction.Axis axis) {
        return Direction.func_181076_a((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
    }

    protected static float horizontalAngleFromDirection(Direction direction) {
        return (Math.max(direction.func_176736_b(), 0) & 3) * 90;
    }

    protected static VoxelShaper forDirectionsWithRotation(VoxelShape shape, Direction facing, Iterable<Direction> directions, Function<Direction, Vec3d> rotationValues) {
        VoxelShaper voxelShaper = new VoxelShaper();
        for (Direction dir : directions) {
            voxelShaper.shapes.put(dir, VoxelShaper.rotate(shape, facing, dir, rotationValues));
        }
        return voxelShaper;
    }

    protected static VoxelShape rotate(VoxelShape shape, Direction from, Direction to, Function<Direction, Vec3d> usingValues) {
        if (from == to) {
            return shape;
        }
        return VoxelShaper.rotatedCopy(shape, usingValues.apply(from).func_216371_e().func_178787_e(usingValues.apply(to)));
    }

    protected static VoxelShape rotatedCopy(VoxelShape shape, Vec3d rotation) {
        if (rotation.equals((Object)Vec3d.field_186680_a)) {
            return shape;
        }
        MutableObject result = new MutableObject((Object)VoxelShapes.func_197880_a());
        Vec3d center = new Vec3d(8.0, 8.0, 8.0);
        shape.func_197755_b((x1, y1, z1, x2, y2, z2) -> {
            Vec3d v1 = new Vec3d(x1, y1, z1).func_186678_a(16.0).func_178788_d(center);
            Vec3d v2 = new Vec3d(x2, y2, z2).func_186678_a(16.0).func_178788_d(center);
            v1 = VecHelper.rotate(v1, (float)rotation.field_72450_a, Direction.Axis.X);
            v1 = VecHelper.rotate(v1, (float)rotation.field_72448_b, Direction.Axis.Y);
            v1 = VecHelper.rotate(v1, (float)rotation.field_72449_c, Direction.Axis.Z).func_178787_e(center);
            v2 = VecHelper.rotate(v2, (float)rotation.field_72450_a, Direction.Axis.X);
            v2 = VecHelper.rotate(v2, (float)rotation.field_72448_b, Direction.Axis.Y);
            v2 = VecHelper.rotate(v2, (float)rotation.field_72449_c, Direction.Axis.Z).func_178787_e(center);
            VoxelShape rotated = Block.func_208617_a((double)v1.field_72450_a, (double)v1.field_72448_b, (double)v1.field_72449_c, (double)v2.field_72450_a, (double)v2.field_72448_b, (double)v2.field_72449_c);
            result.setValue((Object)VoxelShapes.func_197872_a((VoxelShape)((VoxelShape)result.getValue()), (VoxelShape)rotated));
        });
        return (VoxelShape)result.getValue();
    }

    protected static class HorizontalRotationValues
    implements Function<Direction, Vec3d> {
        protected HorizontalRotationValues() {
        }

        @Override
        public Vec3d apply(Direction direction) {
            return new Vec3d(0.0, (double)(-VoxelShaper.horizontalAngleFromDirection(direction)), 0.0);
        }
    }

    protected static class DefaultRotationValues
    implements Function<Direction, Vec3d> {
        protected DefaultRotationValues() {
        }

        @Override
        public Vec3d apply(Direction direction) {
            return new Vec3d(direction == Direction.UP ? 0.0 : (double)(Direction.Plane.VERTICAL.test(direction) ? 180 : 90), (double)(-VoxelShaper.horizontalAngleFromDirection(direction)), 0.0);
        }
    }
}

