/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.worldgen;

import com.simibubi.create.content.curiosities.tools.SandPaperItem;
import java.util.LinkedList;
import java.util.OptionalDouble;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class OxidizingBlock
extends Block {
    public static final IntegerProperty OXIDIZATION = IntegerProperty.func_177719_a((String)"oxidization", (int)0, (int)7);
    private float chance;

    public OxidizingBlock(Block.Properties properties, float chance) {
        super(properties);
        this.chance = chance;
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)OXIDIZATION, (Comparable)Integer.valueOf(0)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder.func_206894_a(new IProperty[]{OXIDIZATION}));
    }

    public boolean func_149653_t(BlockState state) {
        return super.func_149653_t(state) || (Integer)state.func_177229_b((IProperty)OXIDIZATION) < 7;
    }

    public void func_225542_b_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        if (worldIn.func_201674_k().nextFloat() <= this.chance) {
            OptionalDouble average;
            int currentState = (Integer)state.func_177229_b((IProperty)OXIDIZATION);
            boolean canIncrease = false;
            LinkedList<Comparable> neighbors = new LinkedList<Comparable>();
            for (Direction facing : Direction.values()) {
                BlockPos neighbourPos = pos.func_177972_a(facing);
                if (!worldIn.func_195588_v(neighbourPos)) continue;
                BlockState neighborState = worldIn.func_180495_p(neighbourPos);
                if (neighborState.func_196959_b((IProperty)OXIDIZATION) && (Integer)neighborState.func_177229_b((IProperty)OXIDIZATION) != 0) {
                    neighbors.add(neighborState.func_177229_b((IProperty)OXIDIZATION));
                }
                if (Block.func_220056_d((BlockState)neighborState, (IBlockReader)worldIn, (BlockPos)neighbourPos, (Direction)facing.func_176734_d())) continue;
                canIncrease = true;
            }
            if (canIncrease && (average = neighbors.stream().mapToInt(v -> v).average()).orElse(7.0) >= (double)currentState) {
                worldIn.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)OXIDIZATION, (Comparable)Integer.valueOf(Math.min(currentState + 1, 7))));
            }
        }
    }

    public float func_176195_g(BlockState blockState, IBlockReader worldIn, BlockPos pos) {
        return this.field_149782_v - 0.2f * (float)((Integer)blockState.func_177229_b((IProperty)OXIDIZATION)).intValue();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult blockRayTraceResult) {
        if ((Integer)state.func_177229_b((IProperty)OXIDIZATION) > 0 && player.func_184586_b(hand).func_77973_b() instanceof SandPaperItem) {
            if (!player.func_184812_l_()) {
                player.func_184586_b(hand).func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(p.func_184600_cs()));
            }
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)OXIDIZATION, (Comparable)Integer.valueOf(0)));
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }
}

