/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.repack.registrate.builders;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.simibubi.create.repack.registrate.AbstractRegistrate;
import com.simibubi.create.repack.registrate.builders.AbstractBuilder;
import com.simibubi.create.repack.registrate.builders.BuilderCallback;
import com.simibubi.create.repack.registrate.builders.ItemBuilder;
import com.simibubi.create.repack.registrate.builders.TileEntityBuilder;
import com.simibubi.create.repack.registrate.providers.DataGenContext;
import com.simibubi.create.repack.registrate.providers.ProviderType;
import com.simibubi.create.repack.registrate.providers.RegistrateBlockstateProvider;
import com.simibubi.create.repack.registrate.providers.RegistrateRecipeProvider;
import com.simibubi.create.repack.registrate.providers.loot.RegistrateBlockLootTables;
import com.simibubi.create.repack.registrate.providers.loot.RegistrateLootTableProvider;
import com.simibubi.create.repack.registrate.util.entry.BlockEntry;
import com.simibubi.create.repack.registrate.util.entry.RegistryEntry;
import com.simibubi.create.repack.registrate.util.nullness.NonNullBiConsumer;
import com.simibubi.create.repack.registrate.util.nullness.NonNullBiFunction;
import com.simibubi.create.repack.registrate.util.nullness.NonNullFunction;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import com.simibubi.create.repack.registrate.util.nullness.NonNullUnaryOperator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.BlockItem;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.tags.Tag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.world.storage.loot.LootTables;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.RegistryObject;

public class BlockBuilder<T extends Block, P>
extends AbstractBuilder<Block, T, P, BlockBuilder<T, P>> {
    private final NonNullFunction<Block.Properties, T> factory;
    private NonNullSupplier<Block.Properties> initialProperties;
    private NonNullFunction<Block.Properties, Block.Properties> propertiesCallback = NonNullUnaryOperator.identity();
    private List<Supplier<Supplier<RenderType>>> renderLayers = new ArrayList<Supplier<Supplier<RenderType>>>(1);

    public static <T extends Block, P> BlockBuilder<T, P> create(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Block.Properties, T> factory, Material material) {
        return new BlockBuilder<T, P>(owner, parent, name, callback, factory, () -> Block.Properties.func_200945_a((Material)material)).defaultBlockstate().defaultLoot().defaultLang();
    }

    protected BlockBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, NonNullFunction<Block.Properties, T> factory, NonNullSupplier<Block.Properties> initialProperties) {
        super(owner, parent, name, callback, Block.class);
        this.factory = factory;
        this.initialProperties = initialProperties;
    }

    public BlockBuilder<T, P> properties(NonNullUnaryOperator<Block.Properties> func) {
        this.propertiesCallback = this.propertiesCallback.andThen(func);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(Material material, DyeColor color) {
        this.initialProperties = () -> Block.Properties.func_200952_a((Material)material, (DyeColor)color);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(Material material, MaterialColor color) {
        this.initialProperties = () -> Block.Properties.func_200949_a((Material)material, (MaterialColor)color);
        return this;
    }

    public BlockBuilder<T, P> initialProperties(NonNullSupplier<? extends Block> block) {
        this.initialProperties = () -> Block.Properties.func_200950_a((Block)((Block)block.get()));
        return this;
    }

    public BlockBuilder<T, P> addLayer(Supplier<Supplier<RenderType>> layer) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> BlockBuilder.lambda$null$4((Supplier)layer));
        if (this.renderLayers.isEmpty()) {
            this.onRegister(this::registerLayers);
        }
        this.renderLayers.add(layer);
        return this;
    }

    protected void registerLayers(T entry) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> {
            if (this.renderLayers.size() == 1) {
                RenderType layer = this.renderLayers.get(0).get().get();
                RenderTypeLookup.setRenderLayer((Block)entry, (RenderType)layer);
            } else if (this.renderLayers.size() > 1) {
                Set layers = this.renderLayers.stream().map(s -> (RenderType)((Supplier)s.get()).get()).collect(Collectors.toSet());
                RenderTypeLookup.setRenderLayer((Block)entry, layers::contains);
            }
        });
    }

    public BlockBuilder<T, P> simpleItem() {
        return (BlockBuilder)this.item().build();
    }

    public ItemBuilder<BlockItem, BlockBuilder<T, P>> item() {
        return this.item(BlockItem::new);
    }

    public <I extends BlockItem> ItemBuilder<I, BlockBuilder<T, P>> item(NonNullBiFunction<? super T, Item.Properties, ? extends I> factory) {
        return ((ItemBuilder)this.getOwner().item(this, this.getName(), p -> (BlockItem)factory.apply((T)this.get(), (Item.Properties)p)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).model((ctx, prov) -> {
            Optional<String> model = this.getOwner().getDataProvider(ProviderType.BLOCKSTATE).flatMap(p -> p.getExistingVariantBuilder((Block)this.get())).map(b -> (BlockStateProvider.ConfiguredModelList)b.getModels().get(b.partialState())).map(BlockStateProvider.ConfiguredModelList::toJSON).filter(JsonElement::isJsonObject).map(j -> j.getAsJsonObject().get("model")).map(JsonElement::getAsString);
            if (model.isPresent()) {
                prov.withExistingParent(ctx.getName(), model.get());
            } else {
                prov.blockItem(this);
            }
        });
    }

    @Deprecated
    public <TE extends TileEntity> BlockBuilder<T, P> simpleTileEntity(NonNullSupplier<? extends TE> factory) {
        return (BlockBuilder)this.tileEntity(factory).build();
    }

    public <TE extends TileEntity> BlockBuilder<T, P> simpleTileEntity(NonNullFunction<TileEntityType<TE>, ? extends TE> factory) {
        return (BlockBuilder)this.tileEntity(factory).build();
    }

    @Deprecated
    public <TE extends TileEntity> TileEntityBuilder<TE, BlockBuilder<T, P>> tileEntity(NonNullSupplier<? extends TE> factory) {
        return this.getOwner().tileEntity(this, this.getName(), factory).validBlock(this);
    }

    public <TE extends TileEntity> TileEntityBuilder<TE, BlockBuilder<T, P>> tileEntity(NonNullFunction<TileEntityType<TE>, ? extends TE> factory) {
        return this.getOwner().tileEntity(this, this.getName(), factory).validBlock(this);
    }

    public BlockBuilder<T, P> defaultBlockstate() {
        return this.blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry()));
    }

    public BlockBuilder<T, P> blockstate(NonNullBiConsumer<DataGenContext<Block, T>, RegistrateBlockstateProvider> cons) {
        return (BlockBuilder)this.setData(ProviderType.BLOCKSTATE, cons);
    }

    public BlockBuilder<T, P> defaultLang() {
        return (BlockBuilder)this.lang(Block::func_149739_a);
    }

    public BlockBuilder<T, P> lang(String name) {
        return (BlockBuilder)this.lang(Block::func_149739_a, name);
    }

    public BlockBuilder<T, P> defaultLoot() {
        return this.loot(BlockLootTables::func_218492_c);
    }

    public BlockBuilder<T, P> loot(NonNullBiConsumer<RegistrateBlockLootTables, T> cons) {
        return (BlockBuilder)this.setData(ProviderType.LOOT, (ctx, prov) -> prov.addLootAction(RegistrateLootTableProvider.LootType.BLOCK, tb -> {
            if (!((Block)ctx.getEntry()).func_220068_i().equals((Object)LootTables.field_186419_a)) {
                cons.accept((RegistrateBlockLootTables)tb, (Object)ctx.getEntry());
            }
        }));
    }

    public BlockBuilder<T, P> recipe(NonNullBiConsumer<DataGenContext<Block, T>, RegistrateRecipeProvider> cons) {
        return (BlockBuilder)this.setData(ProviderType.RECIPE, cons);
    }

    public BlockBuilder<T, P> tag(Tag<Block> tag) {
        return (BlockBuilder)this.tag(ProviderType.BLOCK_TAGS, tag);
    }

    @Override
    protected T createEntry() {
        Block.Properties properties = this.initialProperties.get();
        properties = this.propertiesCallback.apply(properties);
        return (T)((Block)this.factory.apply(properties));
    }

    @Override
    protected RegistryEntry<T> createEntryWrapper(RegistryObject<T> delegate) {
        return new BlockEntry<T>(this.getOwner(), delegate);
    }

    @Override
    public BlockEntry<T> register() {
        return (BlockEntry)super.register();
    }

    private static /* synthetic */ void lambda$null$4(Supplier layer) {
        Preconditions.checkArgument((boolean)RenderType.func_228661_n_().contains(((Supplier)layer.get()).get()), (Object)("Invalid block layer: " + layer));
    }
}

