/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.repack.registrate.builders;

import com.simibubi.create.repack.registrate.AbstractRegistrate;
import com.simibubi.create.repack.registrate.builders.AbstractBuilder;
import com.simibubi.create.repack.registrate.builders.BuilderCallback;
import com.simibubi.create.repack.registrate.util.nullness.NonNullSupplier;
import com.simibubi.create.repack.registrate.util.nullness.NonnullType;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;

public class ContainerBuilder<T extends Container, S extends Screen, P>
extends AbstractBuilder<ContainerType<?>, ContainerType<T>, P, ContainerBuilder<T, S, P>> {
    private final ContainerFactory<T> factory;
    private final NonNullSupplier<ScreenFactory<T, S>> screenFactory;

    public ContainerBuilder(AbstractRegistrate<?> owner, P parent, String name, BuilderCallback callback, ContainerFactory<T> factory, NonNullSupplier<ScreenFactory<T, S>> screenFactory) {
        super(owner, parent, name, callback, ContainerType.class);
        this.factory = factory;
        this.screenFactory = screenFactory;
    }

    @Override
    @NonnullType
    protected ContainerType<T> createEntry() {
        ContainerType ret = new ContainerType((windowId, inv) -> this.factory.create((ContainerType)this.get(), windowId, inv));
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> ScreenManager.func_216911_a((ContainerType)ret, (type, inv, displayName) -> this.screenFactory.get().create(type, inv, displayName)));
        return ret;
    }

    public static interface ScreenFactory<C extends Container, T extends Screen> {
        public T create(C var1, PlayerInventory var2, ITextComponent var3);
    }

    public static interface ContainerFactory<T extends Container> {
        public T create(ContainerType<T> var1, int var2, PlayerInventory var3);
    }
}

