/*
 * Decompiled with CFR 0.152.
 */
package locusway.overpoweredarmorbar.overlay;

import java.util.List;
import locusway.overpoweredarmorbar.Configs;
import locusway.overpoweredarmorbar.overlay.ArmorIcon;

public class ArmorBar {
    private static void setArmorIconColor(ArmorIcon icon, List<? extends String> colors, int scale, int armorValue) {
        int currentScale = scale;
        int previousScale = scale - 1;
        if (currentScale > colors.size() - 1) {
            currentScale = colors.size() - 1;
        }
        if (previousScale > colors.size() - 1) {
            previousScale = colors.size() - 1;
        }
        if (previousScale < 0) {
            previousScale = 0;
        }
        if (armorValue >= 1) {
            icon.primaryArmorIconColor.setColorFromHex(colors.get(currentScale));
        }
        if (armorValue == 1) {
            icon.secondaryArmorIconColor.setColorFromHex(colors.get(previousScale));
        }
        if (armorValue == 0) {
            icon.primaryArmorIconColor.setColorFromHex(colors.get(previousScale));
        }
    }

    public static ArmorIcon[] calculateArmorIcons(int playerArmorValue) {
        ArmorIcon[] armorIcons = new ArmorIcon[10];
        int scale = playerArmorValue / 20;
        int counter = playerArmorValue - scale * 20;
        if (scale > 0 && counter == 0) {
            --scale;
            counter = 20;
        }
        for (int i = 0; i < 10; ++i) {
            armorIcons[i] = new ArmorIcon();
            ArmorBar.setArmorIconColor(armorIcons[i], (List)Configs.ClientConfig.colorValues.get(), scale, counter);
            if (counter >= 2) {
                armorIcons[i].armorIconType = ArmorIcon.Type.FULL;
                counter -= 2;
                continue;
            }
            if (counter == 1) {
                armorIcons[i].armorIconType = ArmorIcon.Type.HALF;
                --counter;
                continue;
            }
            armorIcons[i].armorIconType = ArmorIcon.Type.NONE;
        }
        return armorIcons;
    }
}

