/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.openloader;

import com.google.common.base.Supplier;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import net.darkhax.openloader.OpenLoader;
import net.minecraft.resources.FilePack;
import net.minecraft.resources.FolderPack;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.IResourcePack;
import net.minecraft.resources.ResourcePackInfo;

public final class OpenLoaderPackFinder
implements IPackFinder {
    public static final OpenLoaderPackFinder DATA = new OpenLoaderPackFinder(new File("openloader/data"));
    public static final OpenLoaderPackFinder RESOUCE = new OpenLoaderPackFinder(new File("openloader/resources"));
    private final File loaderDirectory;

    private OpenLoaderPackFinder(File loaderDirectory) {
        this.loaderDirectory = loaderDirectory;
        try {
            Files.createDirectories(loaderDirectory.toPath(), new FileAttribute[0]);
        }
        catch (IOException e) {
            OpenLoader.LOGGER.error("Failed to initialize loader.", (Throwable)e);
        }
    }

    public <T extends ResourcePackInfo> void func_195730_a(Map<String, T> packs, ResourcePackInfo.IFactory<T> factory) {
        for (File packCandidate : OpenLoaderPackFinder.getFilesFromDir(this.loaderDirectory)) {
            boolean isFolderPack;
            boolean isFilePack = packCandidate.isFile() && packCandidate.getName().endsWith(".zip");
            boolean bl = isFolderPack = !isFilePack && packCandidate.isDirectory() && new File(packCandidate, "pack.mcmeta").isFile();
            if (isFilePack || isFolderPack) {
                String packName = "openloader/" + packCandidate.getName();
                if (packs.containsKey(packName)) {
                    OpenLoader.LOGGER.error("Failed to load pack {}. It's already been loaded?", (Object)packName);
                    continue;
                }
                ResourcePackInfo packInfo = ResourcePackInfo.func_195793_a((String)packName, (boolean)true, this.getAsPack(packCandidate), factory, (ResourcePackInfo.Priority)ResourcePackInfo.Priority.TOP);
                if (packInfo == null) continue;
                packs.put(packName, packInfo);
                continue;
            }
            OpenLoader.LOGGER.error("Failed to load pack from {}. Archive packs must be zips. Folder packs must have a valid pack.mcmeta file.", (Object)packCandidate.getAbsolutePath());
        }
    }

    private Supplier<IResourcePack> getAsPack(File file) {
        return file.isDirectory() ? () -> new FolderPack(file) : () -> new FilePack(file);
    }

    private static File[] getFilesFromDir(File file) {
        File[] files = new File[]{};
        if (file == null) {
            OpenLoader.LOGGER.error("Attempted to read from a null file.");
        } else if (!file.isDirectory()) {
            OpenLoader.LOGGER.error("Can not read from {}. It's not a directory.", (Object)file.getAbsolutePath());
        } else {
            try {
                File[] readFiles = file.listFiles();
                if (readFiles == null) {
                    OpenLoader.LOGGER.error("Could not read from {} due to a system error. This is likely an issue with your computer.", (Object)file.getAbsolutePath());
                } else {
                    files = readFiles;
                }
            }
            catch (SecurityException e) {
                OpenLoader.LOGGER.error("Could not read from {}. Blocked by system level security. This is likely an issue with your computer.", (Object)file.getAbsolutePath(), (Object)e);
            }
        }
        return files;
    }
}

