/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.trashslot.network;

import java.util.function.Supplier;
import net.blay09.mods.trashslot.TrashHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageTrashSlotClick {
    private final ItemStack itemStack;
    private final boolean isRightClick;

    public MessageTrashSlotClick(ItemStack itemStack, boolean isRightClick) {
        this.itemStack = itemStack;
        this.isRightClick = isRightClick;
    }

    public static void encode(MessageTrashSlotClick message, PacketBuffer buf) {
        buf.func_150788_a(message.itemStack);
        buf.writeBoolean(message.isRightClick);
    }

    public static MessageTrashSlotClick decode(PacketBuffer buf) {
        ItemStack itemStack = buf.func_150791_c();
        boolean isRightClick = buf.readBoolean();
        return new MessageTrashSlotClick(itemStack, isRightClick);
    }

    public static void handle(MessageTrashSlotClick message, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            ServerPlayerEntity player = context.getSender();
            if (player == null) {
                return;
            }
            ItemStack actualMouseItem = player.field_71071_by.func_70445_o();
            if (ItemStack.func_77989_b((ItemStack)actualMouseItem, (ItemStack)message.itemStack)) {
                if (actualMouseItem.func_190926_b()) {
                    ItemStack trashStack = TrashHelper.getTrashItem((PlayerEntity)player);
                    ItemStack mouseStack = message.isRightClick ? trashStack.func_77979_a(1) : trashStack;
                    player.field_71071_by.func_70437_b(mouseStack);
                    TrashHelper.setTrashItem((PlayerEntity)player, message.isRightClick ? trashStack : ItemStack.field_190927_a);
                } else {
                    ItemStack trashStack = message.isRightClick ? actualMouseItem.func_77979_a(1) : actualMouseItem;
                    TrashHelper.setTrashItem((PlayerEntity)player, trashStack);
                    player.field_71071_by.func_70437_b(message.isRightClick ? actualMouseItem : ItemStack.field_190927_a);
                }
            }
        });
        context.setPacketHandled(true);
    }
}

