/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.block;

import codechicken.chunkloader.handler.ChickenChunksConfig;
import codechicken.chunkloader.network.ChickenChunksNetwork;
import codechicken.chunkloader.tile.TileChunkLoader;
import codechicken.chunkloader.tile.TileChunkLoaderBase;
import codechicken.lib.packet.PacketCustom;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockChunkLoader
extends Block {
    public static final VoxelShape SHAPE = VoxelShapes.func_197873_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.75, (double)1.0);

    public BlockChunkLoader() {
        super(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200948_a(20.0f, 100.0f).func_200947_a(SoundType.field_185851_d));
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileChunkLoader();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return true;
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!world.field_72995_K) {
            TileChunkLoader tile = (TileChunkLoader)world.func_175625_s(pos);
            if (tile.owner == null) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("chickenchunks.brokentile", new Object[0]));
            } else if (tile.owner.equals(player.func_110124_au()) || ChickenChunksConfig.doesBypassLoaderAccess((ServerPlayerEntity)player)) {
                PacketCustom packet = new PacketCustom(ChickenChunksNetwork.NET_CHANNEL, 1);
                packet.writePos(pos);
                packet.sendToPlayer((ServerPlayerEntity)player);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("chickenchunks.accessdenied", new Object[0]));
            }
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        TileChunkLoaderBase loader = (TileChunkLoaderBase)world.func_175625_s(pos);
        loader.onBlockPlacedBy(placer);
    }
}

