/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.gui;

import codechicken.chunkloader.network.ChunkLoaderCPH;
import codechicken.chunkloader.tile.TileChunkLoader;
import codechicken.lib.texture.TextureUtils;
import com.mojang.blaze3d.platform.GlStateManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class GuiChunkLoader
extends Screen {
    public Button laserButton;
    public Button shapeButton;
    public TileChunkLoader tile;
    private int lastButton;

    public GuiChunkLoader(TileChunkLoader tile) {
        super((ITextComponent)new StringTextComponent("DOOOOOOOT"));
        this.tile = tile;
    }

    public void init() {
        this.addButton((Widget)new Button(this.width / 2 - 20, this.height / 2 - 45, 20, 20, "+", e -> ChunkLoaderCPH.sendShapeChange(this.tile, this.tile.shape, this.tile.radius + 1)));
        this.addButton((Widget)new Button(this.width / 2 - 80, this.height / 2 - 45, 20, 20, "-", e -> ChunkLoaderCPH.sendShapeChange(this.tile, this.tile.shape, this.tile.radius - 1)));
        this.laserButton = new Button(this.width / 2 + 7, this.height / 2 - 60, 75, 20, "-", e -> {
            this.tile.renderInfo.showLasers = !this.tile.renderInfo.showLasers;
        });
        this.addButton((Widget)this.laserButton);
        this.shapeButton = new Button(this.width / 2 + 7, this.height / 2 - 37, 75, 20, "-", e -> ChunkLoaderCPH.sendShapeChange(this.tile, this.lastButton == 1 ? this.tile.shape.prev() : this.tile.shape.next(), this.tile.radius));
        this.addButton((Widget)this.shapeButton);
        this.updateNames();
        super.init();
    }

    public void updateNames() {
        this.laserButton.setMessage(I18n.func_135052_a((String)(this.tile.renderInfo.showLasers ? "chickenchunks.gui.hidelasers" : "chickenchunks.gui.showlasers"), (Object[])new Object[0]));
        this.shapeButton.setMessage(this.tile.shape.getTranslation().func_150254_d());
    }

    public void tick() {
        if (this.minecraft.field_71441_e.func_175625_s(this.tile.func_174877_v()) != this.tile) {
            this.minecraft.field_71462_r = null;
            this.minecraft.field_71417_B.func_198034_i();
        }
        this.updateNames();
        super.tick();
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        this.renderBackground();
        this.drawContainerBackground();
        super.render(p_render_1_, p_render_2_, p_render_3_);
        GlStateManager.func_227722_g_();
        GlStateManager.func_227731_j_();
        this.drawCentered(I18n.func_135052_a((String)"chickenchunks.gui.name", (Object[])new Object[0]), this.width / 2 - 40, this.height / 2 - 74, 0x303030);
        if (this.tile.owner != null) {
            this.drawCentered(this.tile.ownerName.func_150254_d(), this.width / 2 + 44, this.height / 2 - 72, 0x801080);
        }
        this.drawCentered(I18n.func_135052_a((String)"chickenchunks.gui.radius", (Object[])new Object[0]), this.width / 2 - 40, this.height / 2 - 57, 0x404040);
        this.drawCentered("" + this.tile.radius, this.width / 2 - 40, this.height / 2 - 39, 0xFFFFFF);
        int chunks = this.tile.countLoadedChunks();
        this.drawCentered(I18n.func_135052_a((String)(chunks == 1 ? "chickenchunks.gui.chunk" : "chickenchunks.gui.chunks"), (Object[])new Object[]{chunks}), this.width / 2 - 39, this.height / 2 - 21, 0x108000);
        GlStateManager.func_227716_f_();
        GlStateManager.func_227734_k_();
    }

    private void drawCentered(String s, int x, int y, int colour) {
        this.font.func_211126_b(s, (float)x - (float)this.font.func_78256_a(s) / 2.0f, (float)y, colour);
    }

    public boolean mouseClicked(double x, double y, int button) {
        this.lastButton = button;
        if (button == 1) {
            button = 0;
        }
        return super.mouseClicked(x, y, button);
    }

    private void drawContainerBackground() {
        GlStateManager.func_227702_d_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        TextureUtils.changeTexture((String)"chickenchunks:textures/gui/gui_small.png");
        int posx = this.width / 2 - 88;
        int posy = this.height / 2 - 83;
        this.blit(posx, posy, 0, 0, 176, 166);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

