/*
 * Decompiled with CFR 0.152.
 */
package codechicken.chunkloader.tile;

import codechicken.chunkloader.api.IChunkLoader;
import codechicken.chunkloader.api.IChunkLoaderHandler;
import codechicken.chunkloader.network.ChickenChunksNetwork;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class TileChunkLoaderBase
extends TileEntity
implements ITickableTileEntity,
IChunkLoader {
    public UUID owner;
    public ITextComponent ownerName;
    protected boolean loaded = false;
    protected boolean powered = false;
    public RenderInfo renderInfo;
    public boolean active = false;

    public TileChunkLoaderBase(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public CompoundNBT func_189515_b(CompoundNBT tag) {
        super.func_189515_b(tag);
        tag.func_74757_a("powered", this.powered);
        if (this.owner != null) {
            tag.func_218657_a("owner", (INBT)NBTUtil.func_186862_a((UUID)this.owner));
            tag.func_74778_a("owner_name", ITextComponent.Serializer.func_150696_a((ITextComponent)this.ownerName));
        }
        return tag;
    }

    public void func_145839_a(CompoundNBT tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("owner")) {
            this.owner = NBTUtil.func_186860_b((CompoundNBT)tag.func_74775_l("owner"));
            this.ownerName = ITextComponent.Serializer.func_150699_a((String)tag.func_74779_i("owner_name"));
        }
        if (tag.func_74764_b("powered")) {
            this.powered = tag.func_74767_n("powered");
        }
        this.loaded = true;
    }

    public void func_145829_t() {
        super.func_145829_t();
        if (!this.field_145850_b.field_72995_K && this.loaded && !this.powered) {
            this.activate();
        }
        if (this.field_145850_b.field_72995_K) {
            this.renderInfo = new RenderInfo();
        }
    }

    public boolean isPowered() {
        for (Direction face : Direction.field_82609_l) {
            boolean isPowered = TileChunkLoaderBase.isPoweringTo(this.field_145850_b, this.func_174877_v().func_177972_a(face), face);
            if (!isPowered) continue;
            return true;
        }
        return false;
    }

    public static boolean isPoweringTo(World world, BlockPos pos, Direction side) {
        BlockState state = world.func_180495_p(pos);
        return state.func_177230_c().func_180656_a(state, (IBlockReader)world, pos, side) > 0;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (!this.field_145850_b.field_72995_K) {
            this.deactivate();
        }
    }

    public void destroyBlock() {
    }

    public ChunkPos getChunkPosition() {
        return new ChunkPos(this.func_174877_v().func_177958_n() >> 4, this.func_174877_v().func_177952_p() >> 4);
    }

    public void onBlockPlacedBy(LivingEntity entityliving) {
        if (entityliving instanceof PlayerEntity) {
            this.owner = entityliving.func_110124_au();
            this.ownerName = entityliving.func_200200_C_();
        }
        this.activate();
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public String getMod() {
        return "chickenchunks";
    }

    @Override
    public World world() {
        return this.field_145850_b;
    }

    @Override
    public BlockPos pos() {
        return this.func_174877_v();
    }

    @Override
    public void deactivate() {
        if (this.owner == null) {
            return;
        }
        this.loaded = true;
        this.active = false;
        IChunkLoaderHandler.getCapability((IWorld)this.field_145850_b).removeChunkLoader(this);
    }

    @Override
    public void activate() {
        if (this.owner == null) {
            return;
        }
        this.loaded = true;
        this.active = true;
        IChunkLoaderHandler.getCapability((IWorld)this.field_145850_b).addChunkLoader(this);
    }

    @Override
    public boolean isValid() {
        return !this.field_145846_f;
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean nowPowered = this.isPowered();
            if (this.powered != nowPowered) {
                this.powered = nowPowered;
                if (this.powered) {
                    this.deactivate();
                } else {
                    this.activate();
                }
            }
        } else {
            this.renderInfo.update(this);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return INFINITE_EXTENT_AABB;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        PacketCustom packet = new PacketCustom(ChickenChunksNetwork.NET_CHANNEL, 1);
        this.writeToPacket((MCDataOutput)packet);
        return packet.toTilePacket(this.func_174877_v());
    }

    public CompoundNBT func_189517_E_() {
        PacketCustom packet = new PacketCustom(ChickenChunksNetwork.NET_CHANNEL, 1);
        this.writeToPacket((MCDataOutput)packet);
        return packet.writeToNBT(super.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.readFromPacket((MCDataInput)PacketCustom.fromTilePacket((SUpdateTileEntityPacket)pkt));
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.readFromPacket((MCDataInput)PacketCustom.fromNBTTag((CompoundNBT)tag));
    }

    public void writeToPacket(MCDataOutput packet) {
        packet.writeBoolean(this.active);
        packet.writeBoolean(this.owner != null);
        if (this.owner != null) {
            packet.writeUUID(this.owner);
            packet.writeTextComponent(this.ownerName);
        }
    }

    public void readFromPacket(MCDataInput packet) {
        this.active = packet.readBoolean();
        if (packet.readBoolean()) {
            this.owner = packet.readUUID();
            this.ownerName = packet.readTextComponent();
        }
    }

    public double func_145833_n() {
        return 65536.0;
    }

    public static class RenderInfo {
        public int activationCounter;
        public boolean showLasers;

        public void update(TileChunkLoaderBase chunkLoader) {
            if (this.activationCounter < 20 && chunkLoader.active) {
                ++this.activationCounter;
            } else if (this.activationCounter > 0 && !chunkLoader.active) {
                --this.activationCounter;
            }
        }
    }
}

