/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.craftingstation.client;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import mcjty.lib.McJtyLib;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.gui.widgets.Widgets;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolscontrol.modules.craftingstation.CraftingStationModule;
import mcjty.rftoolscontrol.modules.craftingstation.blocks.CraftingStationContainer;
import mcjty.rftoolscontrol.modules.craftingstation.blocks.CraftingStationTileEntity;
import mcjty.rftoolscontrol.modules.craftingstation.network.PacketGetCraftableItems;
import mcjty.rftoolscontrol.modules.craftingstation.network.PacketGetRequests;
import mcjty.rftoolscontrol.modules.craftingstation.util.CraftingRequest;
import mcjty.rftoolscontrol.modules.programmer.client.GuiTools;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GuiCraftingStation
extends GenericGuiContainer<CraftingStationTileEntity, CraftingStationContainer> {
    public static final int WIDTH = 231;
    public static final int HEIGHT = 236;
    private static final ResourceLocation mainBackground = new ResourceLocation("rftoolscontrol", "textures/gui/craftingstation.png");
    private WidgetList recipeList;
    private WidgetList requestList;
    private TextField searchField;
    private Button cancelButton;
    private static List<ItemStack> fromServer_craftables = new ArrayList<ItemStack>();
    private static List<CraftingRequest> fromServer_requests = new ArrayList<CraftingRequest>();
    private int listDirty = 0;

    public static void storeCraftableForClient(List<ItemStack> items) {
        fromServer_craftables = new ArrayList<ItemStack>(items);
    }

    public static void storeRequestsForClient(List<CraftingRequest> requests) {
        fromServer_requests = new ArrayList<CraftingRequest>(requests);
    }

    public GuiCraftingStation(CraftingStationTileEntity te, CraftingStationContainer container, PlayerInventory inventory) {
        super((GenericTileEntity)te, (Container)container, inventory, ManualEntry.EMPTY);
        this.field_146999_f = 231;
        this.field_147000_g = 236;
    }

    public static void register() {
        GuiCraftingStation.register((ContainerType)((ContainerType)CraftingStationModule.CRAFTING_STATION_CONTAINER.get()), GuiCraftingStation::new);
    }

    public void init() {
        super.init();
        Panel toplevel = (Panel)Widgets.positional().background(mainBackground);
        this.initRecipeList(toplevel);
        this.initProgressList(toplevel);
        this.initButtons(toplevel);
        toplevel.bounds(this.field_147003_i, this.field_147009_r, 231, 236);
        this.window = new Window((Screen)this, (AbstractContainerWidget)toplevel);
        this.window.event("cancel", (source, params) -> this.cancelRequest());
    }

    private void initButtons(Panel toplevel) {
        this.searchField = Widgets.textfield((int)5, (int)5, (int)175, (int)16);
        this.cancelButton = (Button)((Button)Widgets.button((int)180, (int)5, (int)46, (int)16, (String)"Cancel").channel("cancel")).tooltips(new String[]{TextFormatting.YELLOW + "Cancel request", "Cancel the currently selected", "crafting request"});
        toplevel.children(new Widget[]{this.cancelButton, this.searchField});
    }

    private void cancelRequest() {
        int selected = this.requestList.getSelected();
        if (selected == -1) {
            return;
        }
        this.sendServerCommandTyped(RFToolsCtrlMessages.INSTANCE, "station.cancel", TypedMap.builder().put(CraftingStationTileEntity.PARAM_INDEX, (Object)selected).build());
    }

    private void initRecipeList(Panel toplevel) {
        this.recipeList = ((WidgetList)Widgets.list((int)5, (int)23, (int)120, (int)128).name("recipes")).propagateEventsToChildren(true).invisibleSelection(true);
        Slider slider = Widgets.slider((int)126, (int)23, (int)9, (int)128).scrollableName("recipes");
        toplevel.children(new Widget[]{this.recipeList, slider});
    }

    private void initProgressList(Panel toplevel) {
        this.requestList = (WidgetList)Widgets.list((int)136, (int)23, (int)80, (int)128).name("requests");
        Slider slider = Widgets.slider((int)217, (int)23, (int)9, (int)128).scrollableName("requests");
        toplevel.children(new Widget[]{this.requestList, slider});
    }

    private void requestLists() {
        RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketGetCraftableItems(((CraftingStationTileEntity)this.tileEntity).func_174877_v()));
        RFToolsCtrlMessages.INSTANCE.sendToServer((Object)new PacketGetRequests(((CraftingStationTileEntity)this.tileEntity).func_174877_v()));
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestLists();
            this.listDirty = 10;
        }
    }

    private void updateRequestList() {
        this.requestList.removeChildren();
        for (CraftingRequest request : fromServer_requests) {
            ItemStack stack = request.getStack();
            Panel panel = (Panel)Widgets.horizontal().desiredWidth(16);
            this.requestList.children(new Widget[]{panel});
            BlockRender blockRender = new BlockRender().renderItem((Object)stack).offsetX(-1).offsetY(-1);
            panel.children(new Widget[]{blockRender});
            boolean failed = request.getFailed() != -1L;
            boolean ok = request.getOk() != -1L;
            panel.children(new Widget[]{Widgets.label((String)(failed ? "Failed!" : (ok ? "Ok" : "Wait (" + request.getTodo() + ")"))).color(failed ? -53200 : (ok ? -13566160 : StyleConfig.colorTextNormal))});
        }
    }

    protected List<String> addCustomLines(List<String> oldList, BlockRender blockRender, ItemStack stack) {
        if (blockRender.getUserObject() instanceof Integer) {
            ArrayList<String> newlist = new ArrayList<String>();
            newlist.add(TextFormatting.GREEN + "Click: " + TextFormatting.WHITE + "craft single");
            newlist.add(TextFormatting.GREEN + "Shift + click: " + TextFormatting.WHITE + "craft amount");
            newlist.add("");
            newlist.addAll(oldList);
            return newlist;
        }
        return oldList;
    }

    private void updateRecipeList() {
        String filterText = this.searchField.getText().toLowerCase().trim();
        fromServer_craftables.sort(Comparator.comparing(r -> r.func_200301_q().func_150254_d()));
        this.recipeList.removeChildren();
        Panel panel = null;
        int index = 0;
        for (final ItemStack stack : fromServer_craftables) {
            String displayName = stack.func_200301_q().func_150254_d();
            if (!filterText.isEmpty() && !displayName.toLowerCase().contains(filterText)) continue;
            if (panel == null || panel.getChildCount() >= 6) {
                panel = (Panel)Widgets.horizontal((int)1, (int)3).desiredHeight(16);
                this.recipeList.children(new Widget[]{panel});
            }
            final BlockRender blockRender = (BlockRender)new BlockRender().renderItem((Object)stack).hilightOnHover(true).offsetX(-1).offsetY(-1).userObject((Object)index);
            ++index;
            blockRender.event(new BlockRenderEvent(){

                public void select() {
                    Object item = blockRender.getRenderItem();
                    if (item != null) {
                        boolean shift = McJtyLib.proxy.isSneaking();
                        Object index = blockRender.getUserObject();
                        if (shift) {
                            GuiCraftingStation.this.askAmountToCraft(stack);
                        } else {
                            GuiCraftingStation.this.requestItem(stack, 1);
                        }
                    }
                }

                public void doubleClick() {
                }
            });
            panel.children(new Widget[]{blockRender});
        }
    }

    private Integer safeParse(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void askAmountToCraft(ItemStack stack) {
        GuiTools.askSomething(this.minecraft, (Screen)this, this.getWindowManager(), 220, 50, "Craft amount:", "", s -> {
            Integer a = this.safeParse((String)s);
            if (a != null) {
                this.requestItem(stack, a);
            }
        });
    }

    private void requestItem(ItemStack stack, int amount) {
        this.sendServerCommandTyped(RFToolsCtrlMessages.INSTANCE, "station.request", TypedMap.builder().put(CraftingStationTileEntity.PARAM_ITEMNAME, (Object)stack.func_77973_b().getRegistryName().toString()).put(CraftingStationTileEntity.PARAM_NBT, (Object)(stack.func_77942_o() ? stack.serializeNBT().toString() : "")).put(CraftingStationTileEntity.PARAM_AMOUNT, (Object)amount).build());
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.requestListsIfNeeded();
        this.updateRecipeList();
        this.updateRequestList();
        if (this.requestList.getSelected() >= this.requestList.getChildCount()) {
            this.requestList.selected(-1);
        }
        this.cancelButton.enabled(this.requestList.getSelected() != -1);
        this.drawWindow();
    }
}

