/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.craftingstation.network;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.McJtyLib;
import mcjty.lib.network.IClientCommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.Logging;
import mcjty.rftoolscontrol.modules.craftingstation.util.CraftingRequest;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketRequestsReady {
    public BlockPos pos;
    public List<CraftingRequest> list;
    public String command;

    public PacketRequestsReady(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.command = buf.func_150789_c(Short.MAX_VALUE);
        int size = buf.readInt();
        if (size != -1) {
            this.list = new ArrayList<CraftingRequest>(size);
            for (int i = 0; i < size; ++i) {
                String id = buf.func_150789_c(Short.MAX_VALUE);
                ItemStack stack = NetworkTools.readItemStack((PacketBuffer)buf);
                int amount = buf.readInt();
                CraftingRequest request = new CraftingRequest(id, stack, amount);
                request.setOk(buf.readLong());
                request.setFailed(buf.readLong());
                this.list.add(request);
            }
        } else {
            this.list = null;
        }
    }

    public PacketRequestsReady(BlockPos pos, String command, List<CraftingRequest> list) {
        this.pos = pos;
        this.command = command;
        this.list = new ArrayList<CraftingRequest>();
        this.list.addAll(list);
    }

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.func_180714_a(this.command);
        if (this.list == null) {
            buf.writeInt(-1);
        } else {
            buf.writeInt(this.list.size());
            for (CraftingRequest item : this.list) {
                buf.func_180714_a(item.getTicket());
                NetworkTools.writeItemStack((PacketBuffer)buf, (ItemStack)item.getStack());
                buf.writeInt(item.getTodo());
                buf.writeLong(item.getOk());
                buf.writeLong(item.getFailed());
            }
        }
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = McJtyLib.proxy.getClientWorld().func_175625_s(this.pos);
            if (!(te instanceof IClientCommandHandler)) {
                Logging.log((String)"TileEntity is not a ClientCommandHandler!");
                return;
            }
            IClientCommandHandler clientCommandHandler = (IClientCommandHandler)te;
            if (!clientCommandHandler.receiveListFromServer(this.command, this.list, Type.create(CraftingRequest.class))) {
                Logging.log((String)("Command " + this.command + " was not handled!"));
            }
        });
        ctx.setPacketHandled(true);
    }
}

