/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.multitank.blocks;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolscontrol.modules.multitank.MultiTankModule;
import mcjty.rftoolscontrol.modules.multitank.blocks.MultiTankContainer;
import mcjty.rftoolscontrol.modules.multitank.util.MultiTankFluidProperties;
import mcjty.rftoolscontrol.modules.multitank.util.MultiTankHandler;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;

public class MultiTankTileEntity
extends GenericTileEntity {
    public static final String CMD_GETFLUIDS = "getFluids";
    public static final String CLIENTCMD_GETFLUIDS = "getFluids";
    public static final int TANKS = 4;
    public static final int MAXCAPACITY = 10000;
    private final MultiTankFluidProperties[] properties = new MultiTankFluidProperties[4];
    private final LazyOptional<MultiTankHandler> fluidHandler = LazyOptional.of(this::createFluidHandler);
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Crafter").containerSupplier((windowId, player) -> new MultiTankContainer((int)windowId, (ContainerFactory)MultiTankContainer.CONTAINER_FACTORY.get(), this.func_174877_v(), this)));
    private MultiTankHandler handler = null;

    public MultiTankTileEntity() {
        super((TileEntityType)MultiTankModule.MULTITANK_TILE.get());
        for (int i = 0; i < 4; ++i) {
            this.properties[i] = new MultiTankFluidProperties(this, FluidStack.EMPTY, 10000);
        }
    }

    public MultiTankFluidProperties[] getProperties() {
        return this.properties;
    }

    protected void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        for (int i = 0; i < 4; ++i) {
            this.properties[i] = new MultiTankFluidProperties(this, FluidStack.loadFluidStackFromNBT((CompoundNBT)info.func_74775_l("f" + i)), 10000);
        }
    }

    protected void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        for (int i = 0; i < 4; ++i) {
            FluidStack contents = this.properties[i].getContents();
            if (contents.isEmpty()) continue;
            CompoundNBT tag = new CompoundNBT();
            contents.writeToNBT(tag);
            info.func_218657_a("f" + i, (INBT)tag);
        }
    }

    @Nonnull
    public <T> List<T> executeWithResultList(String command, TypedMap args, Type<T> type) {
        List rc = super.executeWithResultList(command, args, type);
        if (!rc.isEmpty()) {
            return rc;
        }
        if ("getFluids".equals(command)) {
            ArrayList<FluidStack> result = new ArrayList<FluidStack>(4);
            for (MultiTankFluidProperties property : this.properties) {
                result.add(property.getContents());
            }
            return type.convert(result);
        }
        return Collections.emptyList();
    }

    public <T> boolean receiveListFromServer(String command, List<T> list, Type<T> type) {
        boolean rc = super.receiveListFromServer(command, list, type);
        if (rc) {
            return true;
        }
        if ("getFluids".equals(command)) {
            for (int i = 0; i < 4; ++i) {
                this.properties[i].set((FluidStack)list.get(i));
            }
            return true;
        }
        return false;
    }

    private MultiTankHandler createFluidHandler() {
        return new MultiTankHandler(this);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction facing) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return this.fluidHandler.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

