/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.blocks;

import javax.annotation.Nullable;
import mcjty.lib.blocks.BaseBlock;
import mcjty.lib.builder.BlockBuilder;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.compat.theoneprobe.TOPDriver;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.rftoolscontrol.compat.RFToolsControlTOPDriver;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class ProcessorBlock
extends BaseBlock {
    public ProcessorBlock() {
        super(new BlockBuilder().topDriver((TOPDriver)RFToolsControlTOPDriver.DRIVER).manualEntry(ManualHelper.create((String)"rftoolscontrol:processor/processor")).info(new InfoLine[]{TooltipBuilder.key((String)"message.rftoolscontrol.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header()}).tileEntitySupplier(ProcessorTileEntity::new));
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean p_220069_6_) {
        super.func_220069_a(state, world, pos, blockIn, fromPos, p_220069_6_);
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ProcessorTileEntity) {
            ((ProcessorTileEntity)te).markFluidSlotsDirty();
        }
    }

    public void onNeighborChange(BlockState state, IWorldReader world, BlockPos pos, BlockPos neighbor) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ProcessorTileEntity) {
            ((ProcessorTileEntity)te).markFluidSlotsDirty();
        }
    }

    private int getInputStrength(World world, BlockPos pos, Direction side) {
        return world.func_175651_c(pos.func_177972_a(side), side);
    }

    protected void checkRedstone(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof ProcessorBlock && te instanceof ProcessorTileEntity) {
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            int powered = 0;
            if (this.getInputStrength(world, pos, Direction.DOWN) > 0) {
                ++powered;
            }
            if (this.getInputStrength(world, pos, Direction.UP) > 0) {
                powered += 2;
            }
            if (this.getInputStrength(world, pos, Direction.NORTH) > 0) {
                powered += 4;
            }
            if (this.getInputStrength(world, pos, Direction.SOUTH) > 0) {
                powered += 8;
            }
            if (this.getInputStrength(world, pos, Direction.WEST) > 0) {
                powered += 16;
            }
            if (this.getInputStrength(world, pos, Direction.EAST) > 0) {
                powered += 32;
            }
            processor.setPowerInput(powered);
        }
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        return true;
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof ProcessorBlock && te instanceof ProcessorTileEntity) {
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            return processor.getPowerOut(side.func_176734_d());
        }
        return 0;
    }
}

