/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.processor.network;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import mcjty.lib.McJtyLib;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.processor.vectorart.GfxOp;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketGraphicsReady {
    private BlockPos pos;
    private Map<String, GfxOp> gfxOps;
    private List<String> orderedOps;

    public void toBytes(PacketBuffer buf) {
        buf.func_179255_a(this.pos);
        buf.writeInt(this.gfxOps.size());
        for (Map.Entry<String, GfxOp> entry : this.gfxOps.entrySet()) {
            buf.func_180714_a(entry.getKey());
            entry.getValue().writeToBuf(buf);
        }
        buf.writeInt(this.orderedOps.size());
        for (String op : this.orderedOps) {
            buf.func_180714_a(op);
        }
    }

    public PacketGraphicsReady(PacketBuffer buf) {
        String key;
        int i;
        this.pos = buf.func_179259_c();
        int size = buf.readInt();
        this.gfxOps = new HashMap<String, GfxOp>(size);
        for (i = 0; i < size; ++i) {
            key = buf.func_150789_c(Short.MAX_VALUE);
            GfxOp gfxOp = GfxOp.readFromBuf(buf);
            this.gfxOps.put(key, gfxOp);
        }
        size = buf.readInt();
        this.orderedOps = new ArrayList<String>(size);
        for (i = 0; i < size; ++i) {
            key = buf.func_150789_c(Short.MAX_VALUE);
            this.orderedOps.add(key);
        }
    }

    public PacketGraphicsReady(ProcessorTileEntity processor) {
        this.pos = processor.func_174877_v();
        this.gfxOps = processor.getGfxOps();
        this.orderedOps = processor.getOrderedOps();
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            TileEntity te = McJtyLib.proxy.getClientWorld().func_175625_s(this.pos);
            if (te instanceof ProcessorTileEntity) {
                ProcessorTileEntity processor = (ProcessorTileEntity)te;
                processor.setClientOrderedGfx(this.gfxOps, this.orderedOps);
            }
        });
        ctx.setPacketHandled(true);
    }
}

