/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import mcjty.rftoolscontrol.modules.various.blocks.NodeContainer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class NodeTileEntity
extends GenericTileEntity {
    public static final String CMD_UPDATE = "node.update";
    public static final Key<String> PARAM_NODE = new Key("node", Type.STRING);
    public static final Key<String> PARAM_CHANNEL = new Key("channel", Type.STRING);
    private String channel;
    private String node;
    private BlockPos processor = null;
    private int prevIn = 0;
    private int[] powerOut = new int[]{0, 0, 0, 0, 0, 0};
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Node").containerSupplier((windowId, player) -> new NodeContainer((int)windowId, (ContainerFactory)NodeContainer.CONTAINER_FACTORY.get(), this.func_174877_v(), this)));

    public NodeTileEntity() {
        super((TileEntityType)VariousModule.NODE_TILE.get());
    }

    public String getNodeName() {
        return this.node;
    }

    public String getChannelName() {
        return this.channel;
    }

    public BlockPos getProcessor() {
        return this.processor;
    }

    public void setProcessor(BlockPos processor) {
        this.processor = processor;
        this.func_70296_d();
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            TileEntity te;
            if (this.processor != null && (te = this.func_145831_w().func_175625_s(this.processor)) instanceof ProcessorTileEntity) {
                ProcessorTileEntity processorTileEntity = (ProcessorTileEntity)te;
                processorTileEntity.redstoneNodeChange(this.prevIn, powered, this.node);
            }
            this.prevIn = powered;
        }
        super.setPowerInput(powered);
    }

    public int getPowerOut(Direction side) {
        return this.powerOut[side.ordinal()];
    }

    public void setPowerOut(Direction side, int powerOut) {
        this.powerOut[side.ordinal()] = powerOut;
        this.func_70296_d();
        this.func_145831_w().func_190524_a(this.field_174879_c.func_177972_a(side), this.func_195044_w().func_177230_c(), this.field_174879_c);
    }

    public void func_145839_a(CompoundNBT tagCompound) {
        super.func_145839_a(tagCompound);
        this.prevIn = tagCompound.func_74762_e("prevIn");
        for (int i = 0; i < 6; ++i) {
            this.powerOut[i] = tagCompound.func_74771_c("p" + i);
        }
    }

    protected void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.channel = info.func_74779_i("channel");
        this.node = info.func_74779_i("node");
        this.processor = BlockPosTools.read((CompoundNBT)info, (String)"processor");
    }

    public CompoundNBT func_189515_b(CompoundNBT tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("prevIn", this.prevIn);
        for (int i = 0; i < 6; ++i) {
            tagCompound.func_74774_a("p" + i, (byte)this.powerOut[i]);
        }
        return tagCompound;
    }

    protected void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        if (this.channel != null) {
            info.func_74778_a("channel", this.channel);
        }
        if (this.node != null) {
            info.func_74778_a("node", this.node);
        }
        if (this.processor != null) {
            BlockPosTools.write((CompoundNBT)info, (String)"processor", (BlockPos)this.processor);
        }
    }

    public boolean execute(PlayerEntity playerMP, String command, TypedMap args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_UPDATE.equals(command)) {
            this.node = (String)args.get(PARAM_NODE);
            this.channel = (String)args.get(PARAM_CHANNEL);
            this.markDirtyClient();
            return true;
        }
        return false;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }
}

