/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.McJtyLib;
import mcjty.lib.api.container.CapabilityContainerProvider;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.container.AutomationFilterItemHander;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.NoDirectionItemHander;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.rftoolscontrol.modules.various.VariousModule;
import mcjty.rftoolscontrol.modules.various.blocks.WorkbenchContainer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class WorkbenchTileEntity
extends GenericTileEntity {
    private final NoDirectionItemHander items = this.createItemHandler();
    private final LazyOptional<WorkbenchItemHandler> automationItemHandlerUp = LazyOptional.of(() -> new WorkbenchItemHandler(this.items, Direction.UP));
    private final LazyOptional<WorkbenchItemHandler> automationItemHandlerDown = LazyOptional.of(() -> new WorkbenchItemHandler(this.items, Direction.DOWN));
    private final LazyOptional<WorkbenchItemHandler> automationItemHandlerSide = LazyOptional.of(() -> new WorkbenchItemHandler(this.items, null));
    private final LazyOptional<INamedContainerProvider> screenHandler = LazyOptional.of(() -> new DefaultContainerProvider("Workbench").containerSupplier((windowId, player) -> new WorkbenchContainer((int)windowId, (ContainerFactory)WorkbenchContainer.CONTAINER_FACTORY.get(), this.func_174877_v(), this)).itemHandler(() -> this.items));
    private int realItems = 0;

    public WorkbenchTileEntity() {
        super((TileEntityType)VariousModule.WORKBENCH_TILE.get());
    }

    protected void readInfo(CompoundNBT tagCompound) {
        super.readInfo(tagCompound);
        CompoundNBT info = tagCompound.func_74775_l("Info");
        this.realItems = info.func_74762_e("realItems");
    }

    protected void writeInfo(CompoundNBT tagCompound) {
        super.writeInfo(tagCompound);
        CompoundNBT info = this.getOrCreateInfo(tagCompound);
        info.func_74768_a("realItems", this.realItems);
    }

    private boolean isCraftInputSlot(int slot) {
        return slot >= 0 && slot < 9;
    }

    private boolean isBufferSlot(int slot) {
        return slot >= 10 && slot < 37;
    }

    private boolean isCraftOutput(int slot) {
        return slot == 9;
    }

    @Nullable
    private IRecipe findRecipe(CraftingInventory workInventory) {
        for (IRecipe r : McJtyLib.proxy.getRecipeManager(this.field_145850_b).func_199510_b()) {
            if (r == null || !IRecipeType.field_222149_a.equals(r.func_222127_g()) || !r.func_77569_a((IInventory)workInventory, this.field_145850_b)) continue;
            return r;
        }
        return null;
    }

    private void updateRecipe() {
        if (this.items.getStackInSlot(9).func_190926_b() || this.realItems == 0) {
            CraftingInventory workInventory = this.makeWorkInventory();
            IRecipe recipe = this.findRecipe(workInventory);
            if (recipe != null) {
                ItemStack stack = recipe.func_77572_b((IInventory)workInventory);
                this.items.setStackInSlot(9, stack);
            } else {
                this.items.setStackInSlot(9, ItemStack.field_190927_a);
            }
        }
    }

    private CraftingInventory makeWorkInventory() {
        CraftingInventory workInventory = new CraftingInventory(new Container(null, -1){

            public boolean func_75145_c(PlayerEntity var1) {
                return false;
            }
        }, 3, 3);
        for (int i = 0; i < 9; ++i) {
            workInventory.func_70299_a(i, this.items.getStackInSlot(i + 0));
        }
        return workInventory;
    }

    public void craftItem() {
    }

    private NoDirectionItemHander createItemHandler() {
        return new NoDirectionItemHander(this, (ContainerFactory)WorkbenchContainer.CONTAINER_FACTORY.get()){
            private int crafting;
            {
                this.crafting = 0;
            }

            protected void onUpdate(int index) {
                if (WorkbenchTileEntity.this.isCraftInputSlot(index) && this.crafting <= 0) {
                    WorkbenchTileEntity.this.updateRecipe();
                }
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                CraftingInventory workInventory;
                IRecipe recipe;
                if (simulate) {
                    return super.extractItem(slot, amount, simulate);
                }
                if (WorkbenchTileEntity.this.isCraftOutput(slot) && WorkbenchTileEntity.this.realItems == 0 && (recipe = WorkbenchTileEntity.this.findRecipe(workInventory = WorkbenchTileEntity.this.makeWorkInventory())) != null) {
                    ++this.crafting;
                    NonNullList remainingItems = recipe.func_179532_b((IInventory)workInventory);
                    for (int i = 0; i < 9; ++i) {
                        ItemStack s = WorkbenchTileEntity.this.items.getStackInSlot(i + 0);
                        if (!s.func_190926_b()) {
                            super.extractItem(i + 0, 1, false);
                            s = WorkbenchTileEntity.this.items.getStackInSlot(i + 0);
                        }
                        if (((ItemStack)remainingItems.get(i)).func_190926_b()) continue;
                        if (s.func_190926_b()) {
                            WorkbenchTileEntity.this.items.setStackInSlot(i + 0, (ItemStack)remainingItems.get(i));
                            continue;
                        }
                        if (!ItemStack.func_179545_c((ItemStack)s, (ItemStack)((ItemStack)remainingItems.get(i))) || !ItemStack.func_77970_a((ItemStack)s, (ItemStack)((ItemStack)remainingItems.get(i)))) continue;
                        ItemStack stack = (ItemStack)remainingItems.get(i);
                        stack.func_190917_f(s.func_190916_E());
                        WorkbenchTileEntity.this.items.setStackInSlot(i + 0, (ItemStack)remainingItems.get(i));
                    }
                    --this.crafting;
                }
                ItemStack rc = super.extractItem(slot, amount, false);
                if (WorkbenchTileEntity.this.isCraftOutput(slot)) {
                    ItemStack stack = WorkbenchTileEntity.this.items.getStackInSlot(slot);
                    if (!stack.func_190926_b()) {
                        WorkbenchTileEntity.this.realItems = stack.func_190916_E();
                    } else {
                        WorkbenchTileEntity.this.realItems = 0;
                    }
                }
                if (WorkbenchTileEntity.this.isCraftInputSlot(slot) || WorkbenchTileEntity.this.isCraftOutput(slot)) {
                    WorkbenchTileEntity.this.updateRecipe();
                }
                return rc;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction facing) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.DOWN) {
                return this.automationItemHandlerDown.cast();
            }
            if (facing == Direction.UP) {
                return this.automationItemHandlerUp.cast();
            }
            return this.automationItemHandlerSide.cast();
        }
        if (cap == CapabilityContainerProvider.CONTAINER_PROVIDER_CAPABILITY) {
            return this.screenHandler.cast();
        }
        return super.getCapability(cap, facing);
    }

    public class WorkbenchItemHandler
    extends AutomationFilterItemHander {
        private final Direction direction;

        public WorkbenchItemHandler(@Nullable NoDirectionItemHander wrapped, Direction direction) {
            super(wrapped);
            this.direction = direction;
        }

        public boolean canAutomationInsert(int index) {
            if (this.direction == null) {
                return !WorkbenchTileEntity.this.isCraftOutput(index);
            }
            if (this.direction == Direction.DOWN) {
                return false;
            }
            if (this.direction == Direction.UP) {
                return WorkbenchTileEntity.this.isCraftInputSlot(index);
            }
            return WorkbenchTileEntity.this.isBufferSlot(index);
        }

        public boolean canAutomationExtract(int index) {
            if (this.direction == null) {
                return true;
            }
            if (this.direction == Direction.DOWN) {
                return WorkbenchTileEntity.this.isCraftOutput(index);
            }
            if (this.direction == Direction.UP) {
                return WorkbenchTileEntity.this.isCraftInputSlot(index);
            }
            return WorkbenchTileEntity.this.isBufferSlot(index);
        }
    }
}

