/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.modules.various.items.consolemodule;

import java.util.List;
import java.util.Objects;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsbase.api.screens.IScreenDataHelper;
import mcjty.rftoolsbase.api.screens.IScreenModule;
import mcjty.rftoolscontrol.compat.rftoolssupport.ModuleDataLog;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.blocks.ProcessorTileEntity;
import mcjty.rftoolscontrol.setup.Config;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class ConsoleScreenModule
implements IScreenModule<ModuleDataLog> {
    private DimensionId dim = DimensionId.overworld();
    private BlockPos coordinate = BlockPosTools.INVALID;

    public ModuleDataLog getData(IScreenDataHelper h, World worldObj, long millis) {
        ServerWorld world = WorldTools.getWorld((World)worldObj, (DimensionId)this.dim);
        if (world == null) {
            return null;
        }
        if (!WorldTools.isLoaded((World)world, (BlockPos)this.coordinate)) {
            return null;
        }
        Block block = world.func_180495_p(this.coordinate).func_177230_c();
        if (block != ProcessorModule.PROCESSOR.get()) {
            return null;
        }
        TileEntity te = world.func_175625_s(this.coordinate);
        if (te instanceof ProcessorTileEntity) {
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            List<String> lastMessages = processor.getLastMessages(12);
            return new ModuleDataLog(lastMessages);
        }
        return null;
    }

    public void setupFromNBT(CompoundNBT tagCompound, DimensionId dim, BlockPos pos) {
        if (tagCompound != null) {
            this.coordinate = BlockPosTools.INVALID;
            if (tagCompound.func_74764_b("monitorx")) {
                this.dim = tagCompound.func_74764_b("monitordim") ? DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(tagCompound.func_74779_i("monitordim"))) : DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(tagCompound.func_74779_i("dim")));
                if (Objects.equals(dim, this.dim)) {
                    BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
                    int dx = Math.abs(c.func_177958_n() - pos.func_177958_n());
                    int dy = Math.abs(c.func_177956_o() - pos.func_177956_o());
                    int dz = Math.abs(c.func_177952_p() - pos.func_177952_p());
                    if (dx <= 64 && dy <= 64 && dz <= 64) {
                        this.coordinate = c;
                    }
                }
            }
        }
    }

    public int getRfPerTick() {
        return (Integer)Config.CONSOLEMODULE_RFPERTICK.get();
    }

    public void mouseClick(World world, int x, int y, boolean clicked, PlayerEntity player) {
    }
}

