/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.setup;

import java.util.function.Function;
import java.util.function.Supplier;
import mcjty.lib.compat.MainCompatHandler;
import mcjty.lib.setup.DefaultModSetup;
import mcjty.rftoolscontrol.CommandHandler;
import mcjty.rftoolscontrol.modules.processor.ProcessorModule;
import mcjty.rftoolscontrol.modules.processor.logic.registry.FunctionRegistry;
import mcjty.rftoolscontrol.modules.processor.logic.registry.Functions;
import mcjty.rftoolscontrol.modules.processor.logic.registry.OpcodeRegistry;
import mcjty.rftoolscontrol.modules.processor.logic.registry.Opcodes;
import mcjty.rftoolscontrol.setup.RFToolsCtrlMessages;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;

public class ModSetup
extends DefaultModSetup {
    public ModSetup() {
        this.createTab("rftoolscontrol", () -> new ItemStack((IItemProvider)ProcessorModule.PROCESSOR.get()));
    }

    public void init(FMLCommonSetupEvent e) {
        super.init(e);
        DeferredWorkQueue.runLater(() -> CommandHandler.registerCommands());
        RFToolsCtrlMessages.registerMessages("rftoolsctrl");
        Opcodes.init();
        Functions.init();
    }

    public void processIMC(InterModProcessEvent event) {
        event.getIMCStream().forEach(message -> {
            if ("getOpcodeRegistry".equalsIgnoreCase(message.getMethod())) {
                Supplier supplier = message.getMessageSupplier();
                ((Function)supplier.get()).apply(new OpcodeRegistry());
            } else if ("getFunctionRegistry".equalsIgnoreCase(message.getMethod())) {
                Supplier supplier = message.getMessageSupplier();
                ((Function)supplier.get()).apply(new FunctionRegistry());
            }
        });
    }

    protected void setupModCompat() {
        MainCompatHandler.registerWaila();
        MainCompatHandler.registerTOP();
    }
}

