/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.core.handler;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.melanx.aiotbotania.AIOTBotania;
import de.melanx.aiotbotania.core.Registration;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerModelPart;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.IItemProvider;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.item.ModItems;

public class ContributorHandler
extends LayerRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> {
    public static final Map<String, ItemStack> contributorMap = new HashMap<String, ItemStack>();
    private static boolean startedLoading = false;

    public ContributorHandler(IEntityRenderer<AbstractClientPlayerEntity, PlayerModel<AbstractClientPlayerEntity>> renderer) {
        super(renderer);
    }

    public static void firstStart() {
        if (!startedLoading) {
            new ThreadContributorListLoader();
            startedLoading = true;
        }
    }

    public static void load(Properties props) {
        contributorMap.clear();
        for (String key : props.stringPropertyNames()) {
            String value = props.getProperty(key);
            try {
                int i = Integer.parseInt(value);
                if (i < 0 || i >= 4) {
                    throw new NumberFormatException();
                }
                ItemStack stack = ContributorHandler.getIcon(i);
                contributorMap.put(key, stack);
            }
            catch (NumberFormatException e) {
                AIOTBotania.instance.getLogger().info("Oops, a wrong number at {}. Please report on GitHub. https://www.github.com/MelanX/aiotbotania/issues", (Object)key);
            }
        }
    }

    private static ItemStack getIcon(int i) {
        switch (i) {
            case 0: {
                return ContributorHandler.getItem((IItemProvider)Registration.livingwood_aiot.get());
            }
            case 1: {
                return ContributorHandler.getItem((IItemProvider)Registration.livingrock_aiot.get());
            }
            case 2: {
                return ContributorHandler.getItem((IItemProvider)Registration.manasteel_aiot.get());
            }
            case 3: {
                return ContributorHandler.getItem((IItemProvider)Registration.elementium_aiot.get());
            }
        }
        return ContributorHandler.getItem((IItemProvider)ModItems.grassSeeds);
    }

    private static ItemStack getItem(IItemProvider item) {
        return new ItemStack(item);
    }

    private void renderIcon(MatrixStack ms, IRenderTypeBuffer buffers, PlayerEntity player, ItemStack stack) {
        ms.func_227860_a_();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(AtlasTexture.field_110575_b);
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(180.0f));
        ms.func_227861_a_((double)0.15f, (double)-0.17f, (double)0.13f);
        ms.func_227862_a_(0.15f, 0.15f, 0.15f);
        if (player.func_213453_ef()) {
            ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(30.0f));
            ms.func_227861_a_(0.0, -1.76, 0.2);
        }
        RenderHelper.renderItemCustomColor((LivingEntity)player, (ItemStack)stack, (int)-1, (MatrixStack)ms, (IRenderTypeBuffer)buffers, (int)0xF000F0, (int)OverlayTexture.field_229196_a_);
        ms.func_227865_b_();
    }

    public void render(MatrixStack ms, IRenderTypeBuffer buffers, int light, AbstractClientPlayerEntity player, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (player.func_82150_aj()) {
            return;
        }
        String name = player.func_145748_c_().getString();
        ContributorHandler.firstStart();
        name = name.toLowerCase();
        if (player.func_175148_a(PlayerModelPart.JACKET) && contributorMap.containsKey(name)) {
            this.renderIcon(ms, buffers, (PlayerEntity)player, contributorMap.get(name));
        }
    }

    private static class ThreadContributorListLoader
    extends Thread {
        public ThreadContributorListLoader() {
            this.setName("AIOT Botania Contributor Thread");
            this.setDaemon(true);
            this.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(AIOTBotania.instance.getLogger()));
            this.start();
        }

        @Override
        public void run() {
            try {
                URL url = new URL("https://raw.githubusercontent.com/MelanX/aiotbotania/master/contributors.properties");
                Properties props = new Properties();
                try (InputStreamReader reader = new InputStreamReader(url.openStream(), StandardCharsets.UTF_8);){
                    props.load(reader);
                    ContributorHandler.load(props);
                }
            }
            catch (IOException e) {
                AIOTBotania.instance.getLogger().info("Could not load contributors list. Either you're offline or github is down. Nothing to worry about, carry on~");
            }
        }
    }
}

