/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.items.base;

import de.melanx.aiotbotania.AIOTBotania;
import de.melanx.aiotbotania.items.livingrock.ItemLivingrockAIOT;
import de.melanx.aiotbotania.items.livingwood.ItemLivingwoodAIOT;
import de.melanx.aiotbotania.util.ToolUtil;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FarmlandBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolType;
import vazkii.botania.api.mana.IManaUsingItem;
import vazkii.botania.common.core.helper.ItemNBTHelper;

public class ItemAIOTBase
extends ToolItem
implements IManaUsingItem {
    private final int MANA_PER_DAMAGE;
    private final boolean special;
    private final IItemTier mat;

    public ItemAIOTBase(IItemTier mat, float attackDamage, float attackSpeed, int MANA_PER_DAMAGE, boolean special) {
        super(attackDamage, attackSpeed, mat, new HashSet(), new Item.Properties().func_200916_a(AIOTBotania.instance.getTab()).addToolType(ToolType.AXE, mat.func_200925_d()).addToolType(ToolType.PICKAXE, mat.func_200925_d()).addToolType(ToolType.SHOVEL, mat.func_200925_d()));
        this.MANA_PER_DAMAGE = MANA_PER_DAMAGE;
        this.special = special;
        this.mat = mat;
    }

    public static boolean getBindMode(ItemStack stack) {
        return ItemNBTHelper.getBoolean((ItemStack)stack, (String)"hoemode", (boolean)true);
    }

    public static String getModeString(ItemStack stack) {
        Item tool = stack.func_77973_b();
        if (tool instanceof ItemLivingrockAIOT || tool instanceof ItemLivingwoodAIOT) {
            return "aiotbotania" + (ItemAIOTBase.getBindMode(stack) ? ".hoeMode" : ".utilityMode");
        }
        return "aiotbotania" + (ItemAIOTBase.getBindMode(stack) ? ".hoeModePath" : ".utilityMode");
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int par4, boolean par5) {
        ToolUtil.inventoryTick(stack, world, player, this.MANA_PER_DAMAGE);
    }

    public boolean func_77644_a(ItemStack par1ItemStack, LivingEntity par2EntityLivingBase, @Nonnull LivingEntity par3EntityLivingBase) {
        return ToolUtil.hitEntity(par1ItemStack, par3EntityLivingBase, this.MANA_PER_DAMAGE);
    }

    public boolean func_179218_a(@Nonnull ItemStack stack, @Nonnull World world, @Nonnull BlockState state, @Nonnull BlockPos pos, @Nonnull LivingEntity entity) {
        return ToolUtil.onBlockDestroyed(stack, world, state, pos, entity, this.MANA_PER_DAMAGE);
    }

    @Nonnull
    public ActionResultType func_195939_a(@Nonnull ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        PlayerEntity player = ctx.func_195999_j();
        ItemStack stack = ctx.func_195996_i();
        Direction side = ctx.func_196000_l();
        Block block = world.func_180495_p(pos).func_177230_c();
        boolean hoemode = ItemNBTHelper.getBoolean((ItemStack)stack, (String)"hoemode", (boolean)true);
        if (hoemode) {
            if (!player.func_213453_ef() && (block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == Blocks.field_185774_da || block instanceof FarmlandBlock)) {
                return ToolUtil.hoeUse(ctx, this.special, false, this.MANA_PER_DAMAGE);
            }
            if (side != Direction.DOWN && world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockReader)world, pos.func_177984_a()) && (block == Blocks.field_196658_i || block == Blocks.field_150346_d)) {
                return ToolUtil.shovelUse(ctx, this.MANA_PER_DAMAGE);
            }
            return ActionResultType.PASS;
        }
        if (!player.func_213453_ef()) {
            return ToolUtil.pickUse(ctx);
        }
        if (side == Direction.UP) {
            return ToolUtil.axeUse(ctx);
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (!world.field_72995_K && player.func_213453_ef()) {
            ToolUtil.toggleMode(player, itemStack);
        }
        return ActionResult.func_226248_a_((Object)itemStack);
    }

    public float func_150893_a(@Nonnull ItemStack stack, BlockState state) {
        if (state.func_177230_c() == Blocks.field_196553_aF) {
            return 15.0f;
        }
        return state.func_177230_c().getHarvestTool(state) == null || this.getToolTypes(stack).contains(state.func_177230_c().getHarvestTool(state)) ? this.field_77864_a : 1.0f;
    }

    public boolean usesMana(ItemStack itemStack) {
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> list, ITooltipFlag flags) {
        list.add((ITextComponent)new TranslationTextComponent(ItemAIOTBase.getModeString(stack), new Object[0]));
    }

    public boolean func_150897_b(BlockState block) {
        return block.getHarvestLevel() <= this.mat.func_200925_d();
    }
}

