/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.enchantment;

import cofh.core.enchantment.EnchantmentCoFH;
import cofh.core.util.Utils;
import cofh.core.util.constants.Constants;
import cofh.core.util.references.EnsorcReferences;
import java.util.Map;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnchantmentType;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.HorseArmorItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DisplacementEnchantment
extends EnchantmentCoFH {
    public static int chance = 20;
    public static boolean mobsAffectPlayers = false;

    public DisplacementEnchantment() {
        super(Enchantment.Rarity.RARE, EnchantmentType.ARMOR_CHEST, Constants.ARMOR_SLOTS);
        this.maxLevel = 3;
    }

    public int func_77321_a(int level) {
        return 5 + 10 * (level - 1);
    }

    protected int maxDelegate(int level) {
        return super.func_77321_a(level) + 50;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        Item item = stack.func_77973_b();
        return this.enable && (item instanceof ArmorItem || item instanceof HorseArmorItem || item.isShield(stack, null) || this.supportsEnchantment(stack));
    }

    public boolean func_77326_a(Enchantment ench) {
        return super.func_77326_a(ench) && ench != Enchantments.field_92091_k && ench != EnsorcReferences.FIRE_REBUKE && ench != EnsorcReferences.FROST_REBUKE;
    }

    public void func_151367_b(LivingEntity user, Entity attacker, int level) {
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        Map.Entry stack = EnchantmentHelper.func_222189_b((Enchantment)EnsorcReferences.DISPLACEMENT, (LivingEntity)user);
        if (DisplacementEnchantment.shouldHit(level, user.func_70681_au())) {
            DisplacementEnchantment.onHit(user, attacker, level);
            if (stack != null) {
                ((ItemStack)stack.getValue()).func_222118_a(2, user, entity -> entity.func_213361_c((EquipmentSlotType)stack.getKey()));
            }
        }
    }

    public static void onHit(LivingEntity user, Entity attacker, int level) {
        if (!(attacker instanceof LivingEntity)) {
            return;
        }
        if (user instanceof PlayerEntity || !(attacker instanceof PlayerEntity) || mobsAffectPlayers) {
            Random rand = user.func_70681_au();
            int radius = 8 * (2 ^ level);
            int bound = radius * 2 + 1;
            BlockPos pos = new BlockPos(attacker.func_226277_ct_(), attacker.func_226278_cu_(), attacker.func_226281_cx_());
            BlockPos randPos = pos.func_177982_a(-radius + rand.nextInt(bound), rand.nextInt(8), -radius + rand.nextInt(bound));
            if (attacker.field_70170_p instanceof ServerWorld && attacker.func_184222_aU() && Utils.teleportEntityTo((Entity)attacker, (BlockPos)randPos)) {
                for (int j = 0; j < 3 * level; ++j) {
                    Utils.spawnParticles((World)attacker.field_70170_p, (IParticleData)ParticleTypes.field_197599_J, (double)(attacker.func_226277_ct_() + rand.nextDouble()), (double)(attacker.func_226278_cu_() + 1.0 + rand.nextDouble()), (double)(attacker.func_226281_cx_() + rand.nextDouble()), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
                    Utils.spawnParticles((World)attacker.field_70170_p, (IParticleData)ParticleTypes.field_197599_J, (double)((double)randPos.func_177958_n() + rand.nextDouble()), (double)((double)randPos.func_177956_o() + 1.0 + rand.nextDouble()), (double)((double)randPos.func_177952_p() + rand.nextDouble()), (int)1, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
                }
            }
        }
    }

    public static boolean shouldHit(int level, Random rand) {
        return rand.nextInt(100) < chance * level;
    }
}

