/*
 * Decompiled with CFR 0.152.
 */
package cofh.ensorcellation.event;

import cofh.core.util.constants.Constants;
import cofh.core.util.references.EnsorcReferences;
import cofh.ensorcellation.enchantment.DisplacementEnchantment;
import cofh.ensorcellation.enchantment.FireRebukeEnchantment;
import cofh.ensorcellation.enchantment.FrostRebukeEnchantment;
import cofh.ensorcellation.enchantment.override.ThornsEnchantmentImp;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.enchantment.ThornsEnchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="ensorcellation")
public class ShieldEnchEvents {
    private static final Multimap<String, AttributeModifier> SHIELD_ATTRIBUTES = HashMultimap.create();

    private ShieldEnchEvents() {
    }

    @SubscribeEvent
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        Entity attacker = source.func_76346_g();
        ItemStack stack = entity.func_184607_cu();
        if (ShieldEnchEvents.canBlockDamageSource(entity, source) && attacker != null) {
            PlayerEntity playerAttacker;
            int encBulwark;
            int encFrostRebuke;
            int encFireRebuke;
            int encDisplacement;
            int encThorns = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_92091_k, (ItemStack)stack);
            if (ThornsEnchantmentImp.shouldHit(encThorns, entity.func_70681_au())) {
                attacker.func_70097_a(DamageSource.func_92087_a((Entity)entity), (float)ThornsEnchantment.func_92095_b((int)encThorns, (Random)entity.func_70681_au()));
            }
            if (DisplacementEnchantment.shouldHit(encDisplacement = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.DISPLACEMENT, (ItemStack)stack), entity.func_70681_au())) {
                DisplacementEnchantment.onHit(entity, attacker, encDisplacement);
            }
            if (FireRebukeEnchantment.shouldHit(encFireRebuke = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.FIRE_REBUKE, (ItemStack)stack), entity.func_70681_au())) {
                FireRebukeEnchantment.onHit(entity, attacker, encFireRebuke);
            }
            if (FrostRebukeEnchantment.shouldHit(encFrostRebuke = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.FROST_REBUKE, (ItemStack)stack), entity.func_70681_au())) {
                FrostRebukeEnchantment.onHit(entity, attacker, encFrostRebuke);
            }
            if ((encBulwark = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.BULWARK, (ItemStack)stack)) > 0 && attacker instanceof PlayerEntity && (playerAttacker = (PlayerEntity)attacker).func_70681_au().nextFloat() < 0.5f) {
                playerAttacker.func_184811_cZ().func_185145_a(playerAttacker.func_184614_ca().func_77973_b(), 100);
                attacker.field_70170_p.func_72960_a(attacker, (byte)30);
            }
        }
    }

    @SubscribeEvent
    public static void handleLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity entity = event.getEntityLiving();
        ItemStack stack = entity.func_184607_cu();
        if (stack.func_77973_b().isShield(stack, entity)) {
            HashMultimap attributes = HashMultimap.create();
            int encBulwark = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.BULWARK, (ItemStack)stack);
            int encPhalanx = EnchantmentHelper.func_77506_a((Enchantment)EnsorcReferences.PHALANX, (ItemStack)stack);
            if (encBulwark > 0) {
                attributes.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(Constants.UUID_ENCH_BULWARK_KNOCKBACK_RESISTANCE, "bulwark", 1.0, AttributeModifier.Operation.ADDITION).func_111168_a(false));
            }
            if (encPhalanx > 0) {
                attributes.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(Constants.UUID_ENCH_PHALANX_MOVEMENT_SPEED, "phalanx", 1.25 * (double)encPhalanx, AttributeModifier.Operation.MULTIPLY_TOTAL).func_111168_a(false));
            }
            if (!attributes.isEmpty()) {
                entity.func_110140_aT().func_111147_b((Multimap)attributes);
            }
        } else {
            entity.func_110140_aT().func_111148_a(SHIELD_ATTRIBUTES);
        }
    }

    private static boolean canBlockDamageSource(LivingEntity living, DamageSource source) {
        Vec3d vec3d2;
        AbstractArrowEntity arrow;
        Entity entity = source.func_76364_f();
        if (entity instanceof AbstractArrowEntity && (arrow = (AbstractArrowEntity)entity).func_213874_s() > 0) {
            return false;
        }
        if (!source.func_76363_c() && living.func_184585_cz() && (vec3d2 = source.func_188404_v()) != null) {
            Vec3d vec3d = living.func_70676_i(1.0f);
            Vec3d vec3d1 = vec3d2.func_72444_a(new Vec3d(living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_())).func_72432_b();
            vec3d1 = new Vec3d(vec3d1.field_72450_a, 0.0, vec3d1.field_72449_c);
            return vec3d1.func_72430_b(vec3d) < 0.0;
        }
        return false;
    }

    static {
        SHIELD_ATTRIBUTES.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)new AttributeModifier(Constants.UUID_ENCH_BULWARK_KNOCKBACK_RESISTANCE, "bulwark", 1.0, AttributeModifier.Operation.ADDITION).func_111168_a(false));
        SHIELD_ATTRIBUTES.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)new AttributeModifier(Constants.UUID_ENCH_PHALANX_MOVEMENT_SPEED, "phalanx", 1.25, AttributeModifier.Operation.MULTIPLY_TOTAL).func_111168_a(false));
    }
}

