/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.wawla.plugins.vanilla;

import java.util.List;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.TooltipPosition;
import net.darkhax.wawla.Wawla;
import net.darkhax.wawla.lib.Feature;
import net.minecraft.block.Block;
import net.minecraft.block.EnchantingTableBlock;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class FeatureEnchantmentPower
extends Feature
implements IComponentProvider {
    private static final ResourceLocation TABLE_POWER = new ResourceLocation("wawla", "table_ench_power");
    private static final ResourceLocation BLOCK_POWER = new ResourceLocation("wawla", "block_ench_power");

    @Override
    public void initialize(IRegistrar hwyla) {
        hwyla.addConfig(TABLE_POWER, true);
        hwyla.addConfig(BLOCK_POWER, true);
        hwyla.registerComponentProvider((IComponentProvider)this, TooltipPosition.BODY, Block.class);
    }

    public void appendBody(List<ITextComponent> info, IDataAccessor accessor, IPluginConfig config) {
        float power;
        if (config.get(BLOCK_POWER) && (power = accessor.getBlockState().getEnchantPowerBonus((IWorldReader)accessor.getWorld(), accessor.getPosition())) > 0.0f) {
            info.add(this.getInfoComponent("enchpower", Wawla.FORMAT.format(power)));
        }
        if (config.get(TABLE_POWER) && accessor.getBlock() instanceof EnchantingTableBlock && (power = this.getTotalPower(accessor.getWorld(), accessor.getPosition())) > 0.0f) {
            info.add(this.getInfoComponent("enchpower", Wawla.FORMAT.format(power)));
        }
    }

    private float getTotalPower(World world, BlockPos pos) {
        float power = 0.0f;
        for (int k = -1; k <= 1; ++k) {
            for (int l = -1; l <= 1; ++l) {
                if (k == 0 && l == 0 || !world.func_175623_d(pos.func_177982_a(l, 0, k)) || !world.func_175623_d(pos.func_177982_a(l, 1, k))) continue;
                power += this.getPower(world, pos.func_177982_a(l * 2, 0, k * 2));
                power += this.getPower(world, pos.func_177982_a(l * 2, 1, k * 2));
                if (l == 0 || k == 0) continue;
                power += this.getPower(world, pos.func_177982_a(l * 2, 0, k));
                power += this.getPower(world, pos.func_177982_a(l * 2, 1, k));
                power += this.getPower(world, pos.func_177982_a(l, 0, k * 2));
                power += this.getPower(world, pos.func_177982_a(l, 1, k * 2));
            }
        }
        return power;
    }

    private float getPower(World world, BlockPos pos) {
        return world.func_180495_p(pos).getEnchantPowerBonus((IWorldReader)world, pos);
    }
}

