/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.api;

import com.google.common.base.Objects;
import com.lothrazar.storagenetwork.StorageNetwork;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;

public class DimPos
implements INBTSerializable<CompoundNBT> {
    private int dim;
    private String dimension;
    private BlockPos pos = new BlockPos(0, 0, 0);
    private World world;

    public DimPos() {
    }

    public DimPos(CompoundNBT tag) {
        this.deserializeNBT(tag);
    }

    public DimPos(ByteBuf buf) {
        this.dim = buf.readInt();
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public DimPos(int dimension, String d, BlockPos pos) {
        this.dim = dimension;
        this.dimension = d;
        this.pos = pos;
    }

    public DimPos(World world, BlockPos pos) {
        this.pos = pos;
        this.setWorld(world);
        if (world != null && world.func_201675_m() != null && world.func_201675_m().func_186058_p() != null) {
            this.dim = world.func_201675_m().func_186058_p().func_186068_a();
            this.dimension = world.func_201675_m().func_186058_p().getRegistryName().toString();
        }
    }

    @Nullable
    public World getWorld() {
        return this.world;
    }

    public BlockPos getBlockPos() {
        return this.pos;
    }

    public BlockState getBlockState() {
        return this.getWorld().func_180495_p(this.getBlockPos());
    }

    @Nullable
    public <V> V getTileEntity(Class<V> tileEntityClassOrInterface) {
        return this.getTileEntity(tileEntityClassOrInterface, this.getWorld());
    }

    @Nullable
    public <V> V getTileEntity(Class<V> tileEntityClassOrInterface, World world) {
        TileEntity tileEntity;
        if (world == null || this.getBlockPos() == null) {
            return null;
        }
        if (this.dimension != null && this.dim != world.field_73011_w.func_186058_p().func_186068_a()) {
            if (world.func_73046_m() == null) {
                return null;
            }
            DimensionType dimTarget = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(this.dimension));
            boolean resetUnloadDelay = true;
            boolean forceLoad = true;
            ServerWorld dimWorld = DimensionManager.getWorld((MinecraftServer)world.func_73046_m(), (DimensionType)dimTarget, (boolean)resetUnloadDelay, (boolean)forceLoad);
            if (dimWorld != null) {
                world = dimWorld.func_201672_e();
            }
        }
        if ((tileEntity = world.func_175625_s(this.getBlockPos())) == null) {
            return null;
        }
        if (!tileEntityClassOrInterface.isAssignableFrom(tileEntity.getClass())) {
            return null;
        }
        return (V)tileEntity;
    }

    @Nullable
    public <V> V getCapability(Capability<V> capability, Direction side) {
        World world = this.getWorld();
        if (world == null || this.getBlockPos() == null) {
            return null;
        }
        TileEntity tileEntity = world.func_175625_s(this.getBlockPos());
        if (tileEntity == null) {
            return null;
        }
        return (V)tileEntity.getCapability(capability, side).orElse(null);
    }

    public boolean isLoaded() {
        if (this.getWorld() == null) {
            return false;
        }
        return this.getWorld().func_175667_e(this.pos);
    }

    public boolean equals(World world, BlockPos pos) {
        return pos.equals((Object)this.pos);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DimPos dimPos = (DimPos)o;
        return this.dim == dimPos.dim && Objects.equal((Object)this.pos, (Object)dimPos.pos);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.dim, this.pos});
    }

    public String toString() {
        return "[dimension=" + this.dim + ", pos=" + this.pos + ", world=" + this.getWorld() + ']';
    }

    public void writeToByteBuf(ByteBuf buf) {
        buf.writeInt(this.dim);
        buf.writeInt(this.pos.func_177958_n());
        buf.writeInt(this.pos.func_177956_o());
        buf.writeInt(this.pos.func_177952_p());
    }

    public CompoundNBT serializeNBT() {
        if (this.pos == null) {
            this.pos = new BlockPos(0, 0, 0);
        }
        CompoundNBT result = NBTUtil.func_186859_a((BlockPos)this.pos);
        return result;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.pos = NBTUtil.func_186861_c((CompoundNBT)nbt);
    }

    public DimPos offset(Direction direction) {
        if (this.pos == null || direction == null) {
            StorageNetwork.LOGGER.info("Error: null offset in DimPos " + direction);
            return null;
        }
        return new DimPos(this.getWorld(), this.pos.func_177972_a(direction));
    }

    public IChunk getChunk() {
        return this.getWorld().func_217349_x(this.pos);
    }

    public void setWorld(World world) {
        this.world = world;
    }
}

