/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.block;

import com.lothrazar.storagenetwork.block.TileConnectable;
import com.lothrazar.storagenetwork.block.cable.BlockCable;
import com.lothrazar.storagenetwork.block.main.TileMain;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileCableWithFacing
extends TileConnectable {
    @Nullable
    Direction direction = null;

    public TileCableWithFacing(TileEntityType<?> tileEntityTypeIn) {
        super(tileEntityTypeIn);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BlockPos getFacingPosition() {
        return this.func_174877_v().func_177972_a(this.direction);
    }

    public void setDirection(@Nullable Direction direction) {
        this.direction = direction;
    }

    protected boolean isValidLinkNeighbor(Direction facing) {
        if (facing == null) {
            return false;
        }
        if (!TileMain.isTargetAllowed(this.field_145850_b.func_180495_p(this.field_174879_c.func_177972_a(facing)))) {
            return false;
        }
        TileEntity neighbor = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(facing));
        return neighbor != null && neighbor.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d()).orElse(null) != null;
    }

    public void findNewDirection() {
        for (Direction facing : Direction.values()) {
            if (!this.isValidLinkNeighbor(facing)) continue;
            this.setDirection(facing);
            return;
        }
        this.setDirection(null);
    }

    public void rotate() {
        Direction previous = this.direction;
        List<Direction> targetFaces = Arrays.asList(Direction.values());
        Collections.shuffle(targetFaces);
        for (Direction facing : Direction.values()) {
            TileMain mainNode;
            if (previous == facing || !this.isValidLinkNeighbor(facing)) continue;
            this.setDirection(facing);
            this.func_70296_d();
            if (previous != this.direction && (mainNode = this.getTileMain()) != null) {
                mainNode.refreshNetwork();
            }
            return;
        }
    }

    public void refreshDirection() {
        if (this.getDirection() == null) {
            this.findNewDirection();
            if (this.getDirection() != null) {
                BlockState newState = BlockCable.cleanBlockState(this.func_195044_w());
                newState = (BlockState)newState.func_206870_a((IProperty)BlockCable.FACING_TO_PROPERTY_MAP.get(this.getDirection()), (Comparable)((Object)BlockCable.EnumConnectType.INVENTORY));
                this.field_145850_b.func_175656_a(this.field_174879_c, newState);
            }
        }
    }

    public TileMain getTileMain() {
        if (this.getMain() == null) {
            return null;
        }
        return this.getMain().getTileEntity(TileMain.class);
    }

    @Override
    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.direction = compound.func_74764_b("direction") ? Direction.values()[compound.func_74762_e("direction")] : null;
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        if (this.direction != null) {
            compound.func_74768_a("direction", this.direction.ordinal());
        }
        return super.func_189515_b(compound);
    }
}

