/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.capability.handler;

import com.lothrazar.storagenetwork.api.IItemStackMatcher;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class ItemStackMatcher
implements IItemStackMatcher {
    private ItemStack stack;
    private boolean ore;
    private boolean nbt;

    public ItemStackMatcher(ItemStack stack) {
        this(stack, false, false);
    }

    public ItemStackMatcher(ItemStack stack, boolean ore, boolean nbt) {
        this.stack = stack;
        this.ore = ore;
        this.nbt = nbt;
    }

    private ItemStackMatcher() {
    }

    public void readFromNBT(CompoundNBT compound) {
        CompoundNBT c = (CompoundNBT)compound.func_74781_a("stack");
        this.stack = ItemStack.func_199557_a((CompoundNBT)c);
        this.ore = compound.func_74767_n("ore");
        this.nbt = compound.func_74767_n("nbt");
    }

    public CompoundNBT writeToNBT(CompoundNBT compound) {
        CompoundNBT c = new CompoundNBT();
        this.stack.func_77955_b(c);
        compound.func_218657_a("stack", (INBT)c);
        compound.func_74757_a("ore", this.ore);
        compound.func_74757_a("nbt", this.nbt);
        return c;
    }

    public String toString() {
        return "ItemStackMatcher [stack=" + this.stack + ", ore=" + this.ore + ", nbt=" + this.nbt + "]";
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    public void setStack(@Nonnull ItemStack stack) {
        this.stack = stack;
    }

    public boolean isOre() {
        return this.ore;
    }

    public void setOre(boolean ore) {
        this.ore = ore;
    }

    public boolean isNbt() {
        return this.nbt;
    }

    public void setNbt(boolean nbt) {
        this.nbt = nbt;
    }

    public static ItemStackMatcher loadFilterItemFromNBT(CompoundNBT nbt) {
        ItemStackMatcher fil = new ItemStackMatcher();
        fil.readFromNBT(nbt);
        return fil.getStack() != null && fil.getStack().func_77973_b() != null ? fil : null;
    }

    @Override
    public boolean match(@Nonnull ItemStack stackIn) {
        if (stackIn.func_190926_b()) {
            return false;
        }
        if (this.nbt && !ItemStack.func_77970_a((ItemStack)this.stack, (ItemStack)stackIn)) {
            return false;
        }
        return stackIn.func_77973_b() == this.stack.func_77973_b();
    }
}

