/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class ButtonRequest
extends Button {
    private static final int SIZE = 16;
    private ResourceLocation texture = new ResourceLocation("storagenetwork", "textures/gui/cable.png");
    private TextureEnum textureId = null;

    public ButtonRequest setTexture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public ButtonRequest(int xPos, int yPos, String displayString, Button.IPressable handler) {
        super(xPos, yPos, 16, 16, displayString, handler);
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        super.render(p_render_1_, p_render_2_, p_render_3_);
    }

    public void renderButton(int mouseX, int mouseY, float partial) {
        if (this.texture == null) {
            super.renderButton(mouseX, mouseY, partial);
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        FontRenderer fontrenderer = minecraft.field_71466_p;
        minecraft.func_110434_K().func_110577_a(this.getTexture());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        int k = this.getYImage(this.isHovered());
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.blit(this.x, this.y, 160 + 16 * k, 52, this.width, this.height);
        if (this.textureId != null) {
            this.blit(this.x, this.y, this.textureId.getX(), this.textureId.getY(), this.width, this.height);
        }
        this.renderBg(minecraft, mouseX, mouseY);
        int j = this.getFGColor();
        if (this.getMessage() != null) {
            this.drawCenteredString(fontrenderer, this.getMessage(), this.x + this.width / 2, this.y + (this.height - 8) / 2, j | MathHelper.func_76123_f((float)(this.alpha * 255.0f)) << 24);
        }
    }

    public TextureEnum getTextureId() {
        return this.textureId;
    }

    public void setTextureId(TextureEnum textureId) {
        this.textureId = textureId;
    }

    public static enum TextureEnum {
        ALLOWLIST,
        IGNORELIST,
        SORT_AMT,
        SORT_MOD,
        SORT_NAME,
        SORT_UP,
        SORT_DOWN,
        JEI_RED,
        JEI_GREEN,
        IMPORT,
        PLUS,
        MINUS;


        public int getX() {
            switch (this) {
                case IGNORELIST: {
                    return 195;
                }
                case ALLOWLIST: {
                    return 177;
                }
                case SORT_NAME: {
                    return 198;
                }
                case SORT_AMT: {
                    return 209;
                }
                case SORT_MOD: {
                    return 221;
                }
                case JEI_RED: {
                    return 187;
                }
                case JEI_GREEN: {
                    return 175;
                }
                case SORT_UP: {
                    return 187;
                }
                case SORT_DOWN: {
                    return 175;
                }
                case IMPORT: {
                    return 176;
                }
                case PLUS: {
                    return 196;
                }
                case MINUS: {
                    return 177;
                }
            }
            return 0;
        }

        public int getY() {
            switch (this) {
                case IGNORELIST: 
                case ALLOWLIST: {
                    return 80;
                }
                case SORT_NAME: 
                case SORT_AMT: 
                case SORT_MOD: 
                case SORT_UP: 
                case SORT_DOWN: {
                    return 127;
                }
                case JEI_RED: 
                case JEI_GREEN: {
                    return 140;
                }
                case IMPORT: {
                    return 156;
                }
                case PLUS: {
                    return 13;
                }
                case MINUS: {
                    return 13;
                }
            }
            return 0;
        }
    }
}

