/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.storagenetwork.network;

import com.lothrazar.storagenetwork.block.cable.export.GuiCableExportFilter;
import com.lothrazar.storagenetwork.block.cable.inputfilter.GuiCableImportFilter;
import com.lothrazar.storagenetwork.block.cable.linkfilter.GuiCableFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class RefreshFilterClientMessage {
    private int size;
    private List<ItemStack> stacks;

    private RefreshFilterClientMessage() {
    }

    public RefreshFilterClientMessage(List<ItemStack> stacks) {
        this.stacks = stacks;
        this.size = stacks.size();
    }

    public static void handle(RefreshFilterClientMessage message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ContainerScreen gui;
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiCableFilter) {
                gui = (GuiCableFilter)Minecraft.func_71410_x().field_71462_r;
                gui.setFilterItems(message.stacks);
            }
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiCableImportFilter) {
                gui = (GuiCableImportFilter)Minecraft.func_71410_x().field_71462_r;
                gui.setFilterItems(message.stacks);
            }
            if (Minecraft.func_71410_x().field_71462_r instanceof GuiCableExportFilter) {
                gui = (GuiCableExportFilter)Minecraft.func_71410_x().field_71462_r;
                gui.setFilterItems(message.stacks);
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static RefreshFilterClientMessage decode(PacketBuffer buf) {
        RefreshFilterClientMessage message = new RefreshFilterClientMessage();
        message.size = buf.readInt();
        message.stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < message.size; ++i) {
            ItemStack stack = ItemStack.func_199557_a((CompoundNBT)buf.func_150793_b());
            stack.func_190920_e(buf.readInt());
            message.stacks.add(stack);
        }
        return message;
    }

    public static void encode(RefreshFilterClientMessage msg, PacketBuffer buf) {
        buf.writeInt(msg.size);
        for (ItemStack stack : msg.stacks) {
            buf.func_150786_a(stack.serializeNBT());
            buf.writeInt(stack.func_190916_E());
        }
    }
}

