/*
 * Decompiled with CFR 0.152.
 */
package mekanism.additions.common;

import java.util.UUID;
import javax.annotation.Nonnull;
import mekanism.additions.client.AdditionsClient;
import mekanism.additions.common.config.MekanismAdditionsConfig;
import mekanism.additions.common.entity.SpawnHelper;
import mekanism.additions.common.item.AdditionsSpawnEggItem;
import mekanism.additions.common.registries.AdditionsBlocks;
import mekanism.additions.common.registries.AdditionsEntityTypes;
import mekanism.additions.common.registries.AdditionsItems;
import mekanism.additions.common.registries.AdditionsSounds;
import mekanism.additions.common.voice.VoiceServerManager;
import mekanism.common.Mekanism;
import mekanism.common.Version;
import mekanism.common.base.IModule;
import mekanism.common.config.MekanismModConfig;
import mekanism.common.registration.impl.ItemRegistryObject;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.ParrotEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.event.server.FMLServerStoppingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="mekanismadditions")
public class MekanismAdditions
implements IModule {
    public static final String MODID = "mekanismadditions";
    public static final UUID babySpeedBoostUUID = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    public static final AttributeModifier babySpeedBoostModifier = new AttributeModifier(babySpeedBoostUUID, "Baby speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    public static MekanismAdditions instance;
    public final Version versionNumber;
    public static VoiceServerManager voiceManager;

    public MekanismAdditions() {
        instance = this;
        Mekanism.modulesLoaded.add(instance);
        MekanismAdditionsConfig.registerConfigs(ModLoadingContext.get());
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::serverStarting);
        MinecraftForge.EVENT_BUS.addListener(this::serverStopping);
        modEventBus.addListener(this::onConfigLoad);
        AdditionsItems.ITEMS.register(modEventBus);
        AdditionsBlocks.BLOCKS.register(modEventBus);
        AdditionsEntityTypes.ENTITY_TYPES.register(modEventBus);
        AdditionsSounds.SOUND_EVENTS.register(modEventBus);
        this.versionNumber = new Version(ModLoadingContext.get().getActiveContainer().getModInfo().getVersion());
    }

    public static ResourceLocation rl(String path) {
        return new ResourceLocation(MODID, path);
    }

    public Version getVersion() {
        return this.versionNumber;
    }

    public String getName() {
        return "Additions";
    }

    public void resetClient() {
        AdditionsClient.reset();
    }

    public void launchClient() {
        AdditionsClient.launch();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(() -> {
            SpawnHelper.addSpawns();
            MekanismAdditions.registerSpawnEggDelayed(AdditionsItems.BABY_CREEPER_SPAWN_EGG, AdditionsItems.BABY_ENDERMAN_SPAWN_EGG, AdditionsItems.BABY_SKELETON_SPAWN_EGG, AdditionsItems.BABY_STRAY_SPAWN_EGG, AdditionsItems.BABY_WITHER_SKELETON_SPAWN_EGG);
            ParrotEntity.field_192017_bK.put(AdditionsEntityTypes.BABY_CREEPER.getEntityType(), SoundEvents.field_193792_eN);
            ParrotEntity.field_192017_bK.put(AdditionsEntityTypes.BABY_SKELETON.getEntityType(), SoundEvents.field_193811_fa);
            ParrotEntity.field_192017_bK.put(AdditionsEntityTypes.BABY_STRAY.getEntityType(), SoundEvents.field_193814_fd);
            ParrotEntity.field_192017_bK.put(AdditionsEntityTypes.BABY_WITHER_SKELETON.getEntityType(), SoundEvents.field_193819_fi);
            Mekanism.logger.info("Loaded 'Mekanism: Additions' module.");
        });
    }

    @SafeVarargs
    private static void registerSpawnEggDelayed(ItemRegistryObject<AdditionsSpawnEggItem> ... spawnEggs) {
        DefaultDispenseItemBehavior dispenseBehavior = new DefaultDispenseItemBehavior(){

            @Nonnull
            public ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                Direction direction = (Direction)source.func_189992_e().func_177229_b((IProperty)DispenserBlock.field_176441_a);
                EntityType entityType = ((SpawnEggItem)stack.func_77973_b()).func_208076_b(stack.func_77978_p());
                entityType.func_220331_a(source.func_197524_h(), stack, null, source.func_180699_d().func_177972_a(direction), SpawnReason.DISPENSER, direction != Direction.UP, false);
                stack.func_190918_g(1);
                return stack;
            }
        };
        for (ItemRegistryObject<AdditionsSpawnEggItem> spawnEgg : spawnEggs) {
            ((AdditionsSpawnEggItem)spawnEgg.getItem()).addToEggLookup();
            DispenserBlock.func_199774_a(spawnEgg, (IDispenseItemBehavior)dispenseBehavior);
        }
    }

    private void serverStarting(FMLServerStartingEvent event) {
        if (MekanismAdditionsConfig.additions.voiceServerEnabled.get()) {
            if (voiceManager == null) {
                voiceManager = new VoiceServerManager();
            }
            voiceManager.start();
        }
    }

    private void serverStopping(FMLServerStoppingEvent event) {
        if (MekanismAdditionsConfig.additions.voiceServerEnabled.get()) {
            voiceManager.stop();
        }
    }

    private void onConfigLoad(ModConfig.ModConfigEvent configEvent) {
        ModConfig config = configEvent.getConfig();
        if (config.getModId().equals(MODID) && config instanceof MekanismModConfig) {
            ((MekanismModConfig)config).clearCache();
        }
    }
}

