/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.addons.jei;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.darkhax.bookshelf.util.RecipeUtils;
import net.darkhax.botanypots.BotanyPotHelper;
import net.darkhax.botanypots.BotanyPots;
import net.darkhax.botanypots.crop.CropInfo;
import net.darkhax.botanypots.crop.HarvestEntry;
import net.darkhax.botanypots.soil.SoilInfo;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;

public class CropWrapper
implements IRecipeCategoryExtension {
    private final CropInfo cropInfo;
    private final List<ItemStack> seedItems = NonNullList.func_191196_a();
    private final List<ItemStack> soilItems = NonNullList.func_191196_a();
    private final List<HarvestEntry> drops = NonNullList.func_191196_a();

    public CropWrapper(CropInfo crop) {
        this.cropInfo = crop;
        this.seedItems.addAll(Arrays.asList(crop.getSeed().func_193365_a()));
        for (SoilInfo soil : BotanyPotHelper.getSoilData(RecipeUtils.getActiveRecipeManager()).values()) {
            if (!BotanyPotHelper.isSoilValidForCrop(soil, crop)) continue;
            this.soilItems.addAll(Arrays.asList(soil.getIngredient().func_193365_a()));
        }
        this.drops.addAll(crop.getResults());
    }

    public List<ItemStack> getSeedItems() {
        return this.seedItems;
    }

    public List<ItemStack> getSoilItems() {
        return this.soilItems;
    }

    public List<HarvestEntry> getDrops() {
        return this.drops;
    }

    public void setIngredients(IIngredients ingredients) {
        List pots = BotanyPots.instance.getContent().getBotanyPotBlocks().stream().map(ItemStack::new).collect(Collectors.toList());
        ArrayList<Object> inputs = new ArrayList<Object>();
        inputs.addAll(this.seedItems);
        inputs.addAll(this.soilItems);
        inputs.addAll(pots);
        ingredients.setInputs(VanillaTypes.ITEM, inputs);
        ArrayList<Object> outputs = new ArrayList<Object>();
        for (HarvestEntry entry : this.drops) {
            outputs.add(entry.getItem());
        }
        outputs.addAll(pots);
        ingredients.setOutputs(VanillaTypes.ITEM, outputs);
    }

    public void getTooltip(int slotIndex, boolean input, ItemStack ingredient, List<String> tooltip) {
        if (!ingredient.func_190926_b()) {
            if (input) {
                SoilInfo soil;
                if (slotIndex == 0) {
                    int growthTicks = this.cropInfo.getGrowthTicks();
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"botanypots.tooltip.jei.growthrate", (Object[])new Object[]{growthTicks, CropWrapper.ticksToTime(growthTicks, false)}));
                } else if (slotIndex == 1 && (soil = BotanyPotHelper.getSoilForItem(ingredient)) != null) {
                    int difference = this.cropInfo.getGrowthTicksForSoil(soil) - this.cropInfo.getGrowthTicks();
                    TextFormatting formatting = difference < 0 ? TextFormatting.GREEN : (difference > 0 ? TextFormatting.RED : TextFormatting.GRAY);
                    tooltip.add(formatting + I18n.func_135052_a((String)"botanypots.tooltip.jei.growthmodifier", (Object[])new Object[]{Float.valueOf(soil.getGrowthModifier()), CropWrapper.ticksToTime(difference, true)}));
                }
            } else {
                int outputIndex = slotIndex - 2;
                if (outputIndex < this.drops.size()) {
                    HarvestEntry entry = this.drops.get(outputIndex);
                    tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"botanypots.tooltip.jei.dropchance", (Object[])new Object[]{Float.valueOf(entry.getChance() * 100.0f)}));
                    int rollMin = entry.getMinRolls();
                    int rollMax = entry.getMaxRolls();
                    if (rollMin == rollMax) {
                        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"botanypots.tooltip.jei.rolls", (Object[])new Object[]{rollMin}));
                    } else {
                        tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)"botanypots.tooltip.jei.rollrange", (Object[])new Object[]{rollMin, rollMax}));
                    }
                }
            }
        }
    }

    private static String ticksToTime(int ticks, boolean prefix) {
        String result;
        boolean isPositive = ticks > 0;
        ticks = Math.abs(ticks);
        int i = ticks / 20;
        int j = i / 60;
        String string = result = (i %= 60) < 10 ? j + ":0" + i : j + ":" + i;
        return prefix ? (isPositive ? "+" : "-") + result : result;
    }
}

