/*
 * Decompiled with CFR 0.152.
 */
package jeresources.compatibility.minecraft;

import jeresources.api.distributions.DistributionBase;
import jeresources.api.distributions.DistributionSquare;
import jeresources.api.distributions.DistributionTriangular;
import jeresources.api.distributions.DistributionUnderWater;
import jeresources.api.drop.LootDrop;
import jeresources.api.drop.PlantDrop;
import jeresources.api.restrictions.BiomeRestriction;
import jeresources.api.restrictions.DimensionRestriction;
import jeresources.api.restrictions.Restriction;
import jeresources.compatibility.CompatBase;
import jeresources.compatibility.minecraft.RenderHooks;
import jeresources.entry.DungeonEntry;
import jeresources.entry.MobEntry;
import jeresources.entry.PlantEntry;
import jeresources.entry.WorldGenEntry;
import jeresources.util.LootTableHelper;
import net.minecraft.block.BeetrootBlock;
import net.minecraft.block.Blocks;
import net.minecraft.block.CarrotBlock;
import net.minecraft.block.CropsBlock;
import net.minecraft.block.NetherWartBlock;
import net.minecraft.block.PotatoBlock;
import net.minecraft.block.StemBlock;
import net.minecraft.block.SweetBerryBushBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.boss.dragon.EnderDragonEntity;
import net.minecraft.entity.monster.ElderGuardianEntity;
import net.minecraft.entity.monster.GiantEntity;
import net.minecraft.entity.monster.ShulkerEntity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.passive.SquidEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableManager;

public class MinecraftCompat
extends CompatBase {
    @Override
    public void init(boolean worldGen) {
        this.registerVanillaMobs();
        this.registerDungeonLoot();
        if (worldGen) {
            this.registerOres();
        }
        this.registerVanillaPlants();
    }

    private void registerVanillaMobs() {
        World world = MinecraftCompat.getWorld();
        LootTableManager manager = LootTableHelper.getManager(world);
        LootTableHelper.getAllMobLootTables(world).entrySet().stream().map(entry -> new MobEntry((LivingEntity)entry.getValue(), manager.func_186521_a((ResourceLocation)entry.getKey()))).forEach(this::registerMob);
        this.registerMobRenderHook(BatEntity.class, RenderHooks.BAT);
        this.registerMobRenderHook(EnderDragonEntity.class, RenderHooks.ENDER_DRAGON);
        this.registerMobRenderHook(ElderGuardianEntity.class, RenderHooks.ELDER_GUARDIAN);
        this.registerMobRenderHook(SquidEntity.class, RenderHooks.SQUID);
        this.registerMobRenderHook(GiantEntity.class, RenderHooks.GIANT);
        this.registerMobRenderHook(ShulkerEntity.class, RenderHooks.SHULKER);
    }

    private void registerDungeonLoot() {
        World world = MinecraftCompat.getWorld();
        LootTableManager manager = LootTableHelper.getManager(world);
        LootTableHelper.getAllChestLootTablesResourceLocations().stream().map(resourceLocation -> new DungeonEntry(resourceLocation.func_110623_a(), manager.func_186521_a(resourceLocation))).forEach(this::registerDungeonEntry);
    }

    private void registerOres() {
        this.registerWorldGen(new WorldGenEntry(new ItemStack((IItemProvider)Blocks.field_150369_x), (DistributionBase)new DistributionTriangular(15, 15, 0.001f), true, new LootDrop(new ItemStack((IItemProvider)Items.field_196128_bn, 4, new CompoundNBT()))));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((IItemProvider)Blocks.field_150366_p), (DistributionBase)new DistributionSquare(20, 8, 1, 64), new LootDrop[0]));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((IItemProvider)Blocks.field_150450_ax), (DistributionBase)new DistributionSquare(8, 7, 1, 16), true, new LootDrop(new ItemStack((IItemProvider)Items.field_151137_ax, 4))));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((IItemProvider)Blocks.field_150482_ag), (DistributionBase)new DistributionSquare(1, 7, 1, 16), true, new LootDrop(new ItemStack((IItemProvider)Items.field_151045_i))));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((IItemProvider)Blocks.field_150412_bA), (DistributionBase)new DistributionSquare(6, 1, 4, 32), new Restriction(BiomeRestriction.EXTREME_HILLS), true, new LootDrop(new ItemStack((IItemProvider)Items.field_151166_bC))));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((IItemProvider)Blocks.field_150352_o), (DistributionBase)new DistributionSquare(2, 8, 1, 32), new LootDrop[0]));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((IItemProvider)Blocks.field_150352_o), (DistributionBase)new DistributionSquare(20, 9, 32, 80), new Restriction(BiomeRestriction.BADLANDS), new LootDrop[0]));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((IItemProvider)Blocks.field_150365_q), (DistributionBase)new DistributionSquare(20, 16, 1, 128), true, new LootDrop(new ItemStack((IItemProvider)Items.field_151044_h))));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((IItemProvider)Blocks.field_196766_fg), (DistributionBase)new DistributionSquare(20, 14, 1, 126), new Restriction(DimensionRestriction.NETHER), true, new LootDrop(new ItemStack((IItemProvider)Items.field_151128_bU, 4))));
        this.registerWorldGen(new WorldGenEntry(new ItemStack((IItemProvider)Blocks.field_150435_aG), (DistributionBase)new DistributionUnderWater(0.0035f), new LootDrop(new ItemStack((IItemProvider)Items.field_151119_aD, 4))));
    }

    private void registerVanillaPlants() {
        PlantDrop potato = new PlantDrop(new ItemStack((IItemProvider)Items.field_151174_bG), 1, 4);
        PlantDrop poisonous = new PlantDrop(new ItemStack((IItemProvider)Items.field_151170_bI), 0.02f);
        this.registerPlant(new PlantEntry((PotatoBlock)Blocks.field_150469_bN, potato, poisonous));
        PlantDrop carrot = new PlantDrop(new ItemStack((IItemProvider)Items.field_151172_bF), 1, 4);
        this.registerPlant(new PlantEntry((CarrotBlock)Blocks.field_150459_bM, carrot));
        PlantDrop wheat = new PlantDrop(new ItemStack((IItemProvider)Items.field_151015_O), 1, 1);
        PlantDrop seeds = new PlantDrop(new ItemStack((IItemProvider)Items.field_151014_N), 0, 3);
        this.registerPlant(new PlantEntry((CropsBlock)Blocks.field_150464_aj, wheat, seeds));
        PlantDrop melonSlice = new PlantDrop(new ItemStack((IItemProvider)Items.field_151127_ba), 3, 7);
        this.registerPlant(new PlantEntry((StemBlock)Blocks.field_150394_bc, melonSlice));
        PlantDrop pumpkin = new PlantDrop(new ItemStack((IItemProvider)Blocks.field_150423_aK), 1, 1);
        this.registerPlant(new PlantEntry((StemBlock)Blocks.field_150393_bb, pumpkin));
        PlantDrop beetroot = new PlantDrop(new ItemStack((IItemProvider)Items.field_185164_cV), 1, 1);
        PlantDrop beetrootSeeds = new PlantDrop(new ItemStack((IItemProvider)Items.field_185163_cU), 0, 3);
        this.registerPlant(new PlantEntry((BeetrootBlock)Blocks.field_185773_cZ, beetroot, beetrootSeeds));
        PlantDrop netherWartDrop = new PlantDrop(new ItemStack((IItemProvider)Items.field_151075_bm), 2, 4);
        PlantEntry netherWartEntry = new PlantEntry((NetherWartBlock)Blocks.field_150388_bm, netherWartDrop);
        netherWartEntry.setSoil(Blocks.field_150425_aM.func_176223_P());
        this.registerPlant(netherWartEntry);
        PlantDrop sweetBerriesDrop = new PlantDrop(new ItemStack((IItemProvider)Items.field_222112_pR), 1, 3);
        PlantEntry sweetBerriesEntry = new PlantEntry((SweetBerryBushBlock)Blocks.field_222434_lW, sweetBerriesDrop);
        sweetBerriesEntry.setSoil(Blocks.field_196658_i.func_176223_P());
        this.registerPlant(sweetBerriesEntry);
    }
}

